# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: mp3blaster
Version: 3.2.6
Release: alt1

Group: Sound
Summary: An interactive text-console based mp3 player

License: GPLv2
Url: http://mp3blaster.sourceforge.net

# https://github.com/stragulus/mp3blaster.git
Source: %name-%version.tar

Patch1: mp3blaster-3.2.0-alt-id3cyr.patch
Patch2: mp3blaster-3.2.0-alt-id3show.patch
Patch3: mp3blaster-alt-makefile-system_getopt.patch

BuildRequires: gcc-c++ libncurses-devel libstdc++-devel

%description
Mp3blaster is an audio player with a user-friendly interface that will run
on any text console. The interface is built using ncurses, and features all
common audio player controls. The playlist editor is very flexible and allows
nested groups (albums). Supported audio media: mp3, ogg vorbis, wav, sid and
streaming mp3 over HTTP.

%prep
%setup
%patch1 -p1

# remove own getopt version
%patch3 -p2
rm -fv -- src/getopt*

%build
%add_optflags -Wno-narrowing
%autoreconf
%configure
%make_build --silent --no-print-directory

%install
%makeinstall_std --silent --no-print-directory

%files
%doc AUTHORS ChangeLog CREDITS README TODO
%_bindir/mp3blaster
%_bindir/mp3tag
%_bindir/splay
%_bindir/nmixer
%_datadir/%name/
%_man1dir/mp3blaster.1.*
%_man1dir/nmixer.1.*
%_man1dir/splay.1.*

%changelog
