# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name:     mpc-qt
Version:  24.06
Release:  alt1

Summary:  A clone of Media Player Classic reimplemented in Qt.
License:  GPL-2.0
Group:    Video
Url:      https://github.com/mpc-qt/mpc-qt

Source:   %name-%version.tar
Patch:    %name-%version-%release.patch

BuildRequires: qt6-tools-devel
BuildRequires: qt6-base-devel
BuildRequires: libmpv-devel

%description
Media Player Classic Home Cinema (mpc-hc) is considered by many to be the
quintessential media player for the Windows desktop.
Media Player Classic Qute Theater (mpc-qt) aims to reproduce most of the
interface and functionality of mpc-h.

%prep
%setuph
%patch -p1
rm -rf mpv-dev

%build
%qmake_qt6 PREFIX=%prefix MPCQT_VERSION=%version
%make_build

%install
%makeinstall_std INSTALL_ROOT=%buildroot
rm -r %buildroot%_defaultdocdir/%name

%files
%_bindir/%name
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%doc DOCS/ipc.md

%changelog
