Name: msgpack-cxx
Version: 6.1.0
Release: alt1

Summary: MessagePack implementation for C++

License: BSL-1.0
Group: System/Libraries
Url: http://msgpack.org

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/msgpack/msgpack-c/releases/download/cpp-%version/msgpack-cxx-%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake

BuildRequires: boost-devel
BuildRequires: cmake zlib-devel
BuildRequires: gcc-c++ >= 4.8

# for %%check
BuildRequires: ctest libgtest-devel

%description
MessagePack is a binary-based efficient object serialization
library. It enables to exchange structured objects between many
languages like JSON. But unlike JSON, it is very fast and small.

%package devel
Summary: MessagePack implementation for C++
Group: Development/C++
Requires: cmake
Obsoletes: libmsgpack < 6.1.0
Obsoletes: libmsgpack-devel < 6.1.0

%description devel
MessagePack is a binary-based efficient object serialization
library. It enables to exchange structured objects between many
languages like JSON. But unlike JSON, it is very fast and small.

%prep
%setup
#patch0 -p2
#patch1 -p1

%build
%cmake_insource \
    -DMSGPACK_BUILD_TESTS=ON \
    -DMSGPACK_CXX17=ON
%make_build

%check
export LD_LIBRARY_PATH=$(pwd)
%make test

%install
%makeinstall_std

%files devel
%doc AUTHORS COPYING ChangeLog LICENSE_1_0.txt NOTICE README README.md
%_includedir/msgpack/
%_includedir/msgpack.hpp
%_libdir/cmake/msgpack-cxx/

%changelog
