Name: nano
Version: 8.0
Release: alt1

Summary: a user-friendly editor, a Pico clone with enhancements
License: %gpl3plus & %fdl v1.2+
Group: Editors
Url: https://nano-editor.org/
Packager: Artem Zolochevskiy <azol@altlinux.org>


# https://nano-editor.org/dist/v5/nano-5.8.tar.xz
Source:  %name-%version.tar
Patch1:  %name-8.0-build.patch

BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Sun Jun 16 2024
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config groff-base libgpg-error libncurses-devel libtinfo-devel perl perl-Encode perl-Text-Unidecode perl-Unicode-EastAsianWidth perl-Unicode-Normalize perl-libintl perl-parent perl-unicore pkg-config sh5 shared-mime-info xz
BuildRequires: groff-extra libmagic-devel libncursesw-devel makeinfo

# Manually added
BuildRequires: desktop-file-utils

BuildRequires: makeinfo

%description
GNU nano is a small and friendly text editor. It aims to emulate the
Pico text editor while also offering several enhancements.

%package desktop
Summary: Dektop file to %name
Group: Editors
License: %gpl3plus & %fdl v1.2+
Requires: %name >= %version

%description desktop
Dektop file to %name

%prep
%setup

%patch1 -p1


%build
%autoreconf

%configure \
  --with-gnu-ld  \
  --enable-utf8

%make_build

%install
%makeinstall_std

# install config file, include all existing syntax definitions
install -d %buildroot%_sysconfdir
sed 's/^# include "/include "/' doc/sample.nanorc > %buildroot%_sysconfdir/nanorc

# install doc files
install -pm644 AUTHORS IMPROVEMENTS NEWS README THANKS TODO %buildroot%_docdir/%name
xz %buildroot%_docdir/%name/NEWS
install -pm644 doc/sample.nanorc %buildroot%_docdir/%name/sample.nanorc
mv %buildroot%_docdir/%name %buildroot%_docdir/%name-%version

# install icons
install -Dpm644 .alt/%name-16x16.png %buildroot%_miconsdir/%name.png
install -Dpm644 .alt/%name-32x32.png %buildroot%_niconsdir/%name.png
install -Dpm644 .alt/%name-48x48.png %buildroot%_liconsdir/%name.png

# install .desktop file
desktop-file-install --dir %buildroot%_desktopdir .alt/%name.desktop

# list of language specific files
%find_lang --all-name %name

%files -f %name.lang
%doc %_docdir/%name-%version
%_bindir/*
%_datadir/%name/
%_infodir/*
%_man1dir/*
%_man5dir/*
%config(noreplace) %_sysconfdir/nanorc

%files desktop
%_desktopdir/*
%_miconsdir/*
%_niconsdir/*
%_liconsdir/*

%changelog
