%define libnettle_soname 8
%define libhogweed_soname 6

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: nettle
Version: 3.10.1
Release: alt1
Summary: A low-level cryptographic library

License: GPL-2.0-or-later or LGPL-3.0-or-later
Group: System/Libraries
Url: https://www.lysator.liu.se/~nisse/nettle/

Vcs: https://git.lysator.liu.se/nettle/nettle.git
Source: %name-%version-%release.tar

BuildRequires: gcc-c++ libgmp-devel libssl-devel makeinfo

%define libnettle libnettle%libnettle_soname
%define libhogweed libhogweed%libhogweed_soname

%description
Nettle is a cryptographic library that is designed to fit easily in more
or less any context: in crypto toolkits for object-oriented languages
(C++, Python, Pike, ...), in applications like LSH or GNUPG, or even in
kernel space.

%package -n %libnettle
Summary: A low-level cryptographic library (symmetric and one-way cryptos)
Group: System/Libraries

%description -n %libnettle
Nettle is a cryptographic library that is designed to fit easily in more
or less any context: in crypto toolkits for object-oriented languages
(C++, Python, Pike, ...), in applications like LSH or GNUPG, or even in
kernel space.

This package contains the symmetric and one-way cryptographic
algorithms. To avoid having this package depend on libgmp, the
asymmetric cryptos reside in a separate library, libhogweed.

%package -n %libhogweed
Summary: A low-level cryptographic library (asymmetric cryptos)
Group: System/Libraries

%description -n %libhogweed
Nettle is a cryptographic library that is designed to fit easily in more
or less any context: in crypto toolkits for object-oriented languages
(C++, Python, Pike, ...), in applications like LSH or GNUPG, or even in
kernel space.

This package contains the asymmetric cryptographic algorithms, which,
require the GNU multiple precision arithmetic library (libgmp) for
their large integer computations.

%package -n lib%name-devel
Summary: Header files, libraries and development documentation for %name
Group: Development/C
Requires: %libnettle = %version-%release
Requires: %libhogweed = %version-%release

%description -n lib%name-devel
Nettle is a cryptographic library that is designed to fit easily in more
or less any context: in crypto toolkits for object-oriented languages
(C++, Python, Pike, ...), in applications like LSH or GNUPG, or even in
kernel space.

This package contains header files, development libraries and
development documentation for %name and libhogweed.

%prep
%setup -n %name-%version-%release
sed -i 's/ -ggdb3//' configure.ac
sed -i -e 's/libnettle\.a/\$(LIBNETTLE_FORLINK)/' \
       -e 's/libhogweed\.a/\$(LIBHOGWEED_FORLINK)/' */Makefile.in

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
%ifarch ppc64le
	--disable-assembler \
%endif
	--disable-static
%make_build LIBTARGETS= DOCTARGETS=nettle.info

%install
%makeinstall_std install-shared LIBTARGETS= DOCTARGETS=nettle.info

%check
%make_build -k check

%files
%_bindir/*

%files -n %libnettle
%_libdir/libnettle.so.%{libnettle_soname}
%_libdir/libnettle.so.%{libnettle_soname}.*
%doc AUTHORS NEWS README COPYING*

%files -n %libhogweed
%_libdir/libhogweed.so.%{libhogweed_soname}
%_libdir/libhogweed.so.%{libhogweed_soname}.*

%files -n lib%name-devel
%_pkgconfigdir/*.pc
%_libdir/lib*.so
%_includedir/*
%_infodir/*.*

%changelog
