%ifnarch %ocaml_native_arch
%define relax_check ||:
%else
%define relax_check %nil
%endif

%define libname alcotest
Name: ocaml-%libname
Version: 1.8.0
Release: alt1
Summary: Alcotest is a lightweight and colourful test framework.
Group: Development/ML
License: ISC
Url: https://github.com/mirage/alcotest
VCS: https://github.com/mirage/alcotest
Source0: %name-%version.tar
Patch0: %name-%version-%release.patch
BuildRequires: dune >= 1.8
BuildRequires: ocaml
BuildRequires: ocaml-uutf-devel
BuildRequires: ocaml-cmdliner-devel
BuildRequires: ocaml-re-devel
BuildRequires: ocaml-astring-devel
BuildRequires: ocaml-uuidm-devel
BuildRequires: ocaml-fmt-devel
BuildRequires: libev-devel

%description
Alcotest exposes simple interface to perform unit tests. It exposes a simple
TESTABLE module type, a check function to assert test predicates and a run
function to perform a list of unit -> unit test callbacks.

Alcotest provides a quiet and colorful output where only faulty runs are fully
displayed at the end of the run (with the full logs ready to inspect), with a
simple (yet expressive) query language to select the tests to run.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup
%patch0 -p1

%build
%dune_build -p %libname

%install
%dune_install %libname
rm -rf %buildroot/usr/doc


%check
%dune_check -p %libname %relax_check

%files -f ocaml-files.runtime
%doc README.md

%files devel -f ocaml-files.devel

%changelog
