%define libname bos
Name:           ocaml-%libname
Version:        0.2.1
Release:        alt3
Summary:        Basic OS interaction for OCaml
License:        ISC
Group:          Development/ML
Url:            https://erratique.ch/software/bos
VCS: https://github.com/dbuenzli/bos
Source: %name-%version.tar

BuildRequires: ocaml-findlib-devel ocaml-ocamlbuild ocaml-topkg-devel ocaml >= 4.07.1 opam
BuildRequires: ocaml-astring-devel ocaml-rresult-devel ocaml-fpath-devel ocaml-fmt-devel ocaml-logs-devel
BuildRequires(pre): rpm-build-ocaml >= 1.6

%package devel
Summary: Development files for programs which will use the BOS library
Group: Development/ML
Requires: %name = %EVR

%description
Bos provides support for basic and robust interaction with the operating system 
in OCaml. It has functions to access the process environment, parse command line
arguments, interact with the file system and run command line programs.

Bos works equally well on POSIX and Windows operating systems.

%description devel
This package includes development files necessary for developing 
programs which use %name

%prep
%setup

%build
ocaml pkg/pkg.ml build

%install
sed -i 's,%%%%VERSION_NUM%%%%,%version,g' pkg/META
opam-installer --prefix=%buildroot%prefix --libdir=%buildroot%_libdir/ocaml
%ocaml_find_files

%files -f ocaml-files.runtime
%doc LICENSE.md CHANGES.md README.md

%files devel -f ocaml-files.devel

%changelog
