%ifarch %ocaml_native_arch
%def_with native
%endif
%define pkgname camlzip
Name: ocaml-%pkgname
Version: 1.13
Release: alt2
Summary: OCaml library for reading and writing zip, jar and gzip files
Group: Development/ML
License: LGPLv2.1+ with OCaml-LGPL-linking-exception
Url: https://github.com/xavierleroy/camlzip
VCS: https://github.com/xavierleroy/camlzip
Source: %name-%version.tar

BuildRequires(pre): rpm-build-ocaml >= 1.6
BuildRequires: ocaml zlib-devel ocaml-findlib
Provides: ocaml-zip = %EVR
Obsoletes: ocaml-zip < %EVR


%description
This Objective Caml library provides easy access to compressed files
in ZIP and GZIP format, as well as to Java JAR files. It provides
functions for reading from and writing to compressed files in these
formats.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %EVR
Provides: ocaml-zip-devel = %EVR
Obsoletes: ocaml-zip-devel <= %EVR
Requires: zlib-devel

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
%make_build allbyt
%if_with native
%make_build allopt
%endif

%install
export OCAMLFIND_LDCONF=ignore
export DESTDIR=%buildroot
export OCAMLFIND_DESTDIR=%buildroot%_ocamldir
export EXT_DLL=.so
mkdir -p %buildroot%_ocamldir
mkdir -p %buildroot%_ocamldir/stublibs
%make install

%ocaml_find_files


%files -f ocaml-files.runtime

%files devel -f ocaml-files.devel

%changelog
