%define libname cppo_ocamlbuild
Name: ocaml-cppo
Version: 1.8.0
Release: alt2
Summary: Equivalent of the C preprocessor for OCaml programs
License: BSD
Group: Development/ML
Url: https://github.com/mjambon/cppo 
VCS: https://github.com/mjambon/cppo 
Source0: %name-%version.tar
BuildRequires: dune ocaml ocaml-ocamlbuild-devel ocaml-findlib-devel

%description
Cppo is an equivalent of the C preprocessor targeted at the OCaml
language and its variants.

The main purpose of cppo is to provide a lightweight tool for simple
macro substitution (\#define) and file inclusion (\#include) for the
occasional case when this is useful in OCaml. Processing specific
sections of files by calling external programs is also possible via
\#ext directives.

The implementation of cppo relies on the standard library of OCaml and
on the standard parsing tools Ocamllex and Ocamlyacc, which contribute
to the robustness of cppo across OCaml versions.

%package -n ocaml-%libname
Summary: ocamlbuild support for cppo, OCaml-friendly source preprocessor
Group: Development/ML
%description -n ocaml-%libname
ocamlbuild support for cppo, OCaml-friendly source preprocessor

%package -n ocaml-%libname-devel
Summary: Development files for %name-ocamlbuild
Group: Development/ML
Requires: ocaml-%libname = %EVR
%description -n ocaml-%libname-devel
The %name-ocamlbuild-devel package contains libraries and signature files for
developing applications that use %name-ocamlbuild.

%prep
%setup 

%build
%dune_build --release @install

%install
%dune_install

%check
%dune_check

%files
%doc LICENSE.md README.md
%_bindir/cppo
%_libdir/ocaml/cppo

%files -n ocaml-%libname -f ocaml-files.runtime
%exclude %_libdir/ocaml/cppo/META

%files -n ocaml-%libname-devel -f ocaml-files.devel
%exclude %_libdir/ocaml/cppo/opam
%exclude %_libdir/ocaml/cppo/dune-package

%changelog
