%define libname csexp
%def_without check

Name:           ocaml-%libname
Version:        1.5.2
Release:        alt1
Summary:        Canonical S-expressions for OCaml
License:        MIT
Group:          Development/ML
Url:            https://github.com/ocaml-dune/csexp
Source: %name-%version.tar

BuildRequires: ocaml dune rpm-build-ocaml
%if_with check
BuildRequires: ocaml-ppx_expect-devel
%endif

%package devel
Summary: Development files for programs which will use the %name
Group: Development/ML
Requires: %name = %version-%release

%description
This library provides minimal support for Canonical S-expressions [1]. Canonical
S-expressions are a binary encoding of S-expressions that is super simple and
well suited for communication between programs.

%description devel
This package includes development files necessary for developing
programs which use %name

%prep
%setup -q

%build
sed '3 i (version %version)' dune-project
%dune_build -p %libname

%install
%dune_install

%check
%dune_check

%files -f ocaml-files.runtime
%doc LICENSE.md CHANGES.md README.md

%files devel -f ocaml-files.devel

%changelog
