%define ocamlmod easy-format
Name: ocaml-%ocamlmod
Version: 1.3.4
Release: alt1
Summary: High-level and functional interface to the Format module
License: BSD-3-Clause
Group: Development/ML
Url: https://github.com/ocaml-community/easy-format
Source: %name-%version.tar
BuildRequires: ocaml >= 4.04
BuildRequires: ocaml-ocamldoc
BuildRequires: dune

%description
This module offers a high-level and functional interface to the Format
module of the OCaml standard library. It is a pretty-printing
facility, i.e. it takes as input some code represented as a tree and
formats this code into the most visually satisfying result, breaking
and indenting lines of code where appropriate.

Input data must be first modeled and converted into a tree using 3
kinds of nodes:

    atoms
    lists
    labeled nodes

Atoms represent any text that is guaranteed to be printed as-is. Lists
can model any sequence of items such as arrays of data or lists of
definitions that are labeled with something like "int main", "let x
=" or "x:".

%package devel
Summary: Development files for %name
Requires: %name = %version-%release
Group: Development/ML

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
%dune_build -p %ocamlmod

%install
%dune_install

%check
%dune_check

%files -f ocaml-files.runtime
%doc LICENSE

%files devel -f ocaml-files.devel
%doc LICENSE README.md CHANGES.md

%changelog
