%define pkgname ocamlbuild
%ifarch %ocaml_native_arch
%define native true
%else
%define native false
%endif
Name: ocaml-%pkgname
Version: 0.15.0
Release: alt1
Epoch: 1
Summary: The Objective Caml project compilation tool
License: LGPLv2 with OCaml-LGPL-linking-exception
Group: Development/ML
Url: https://github.com/ocaml/ocamlbuild

Source: %name-%version.tar
Source1: ocaml-ocamlbuild.watch
Patch0: %name-%version-%release.patch
BuildRequires: rpm-build-ocaml >= 1.6

BuildRequires: ocaml >= 4.14

%description
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

This package provides ocamlbuild, a tool automating the compilation
of OCaml projects.

%package devel
Summary: Development files for %name
Requires: %name = %EVR
Group: Development/ML

%description devel
This package contains development files for %name.

%prep
%setup
%patch0 -p1

%build
%add_optflags -DUSE_NON_CONST -D_FILE_OFFSET_BITS=64

make configure \
  OCAMLBUILD_PREFIX=%{_prefix} \
  OCAMLBUILD_BINDIR=%{_bindir} \
  OCAMLBUILD_LIBDIR=%{_libdir}/ocaml \
  OCAMLBUILD_MANDIR=%{_mandir} \
%ifarch %{ocaml_native_arch}
  OCAML_NATIVE=true \
  OCAML_NATIVE_TOOLS=true
%else
  OCAML_NATIVE=false \
  OCAML_NATIVE_TOOLS=false
%endif

make \
%ifarch %{ocaml_native_arch}
     OCAMLC="ocamlc.opt -g -bin-annot" \
     OCAMLOPT="ocamlopt.opt -g"
%else
     OCAMLC="ocamlc -g -bin-annot" \
     OCAMLOPT="ocamlopt -g"
%endif

%install
%makeinstall_std CHECK_IF_PREINSTALLED=false

%ocaml_find_files

%files -f ocaml-files.runtime
%doc Changes Readme.md LICENSE
%_bindir/ocamlbuild
%_bindir/ocamlbuild.byte
%ifarch %ocaml_native_arch
%_bindir/ocamlbuild.native
%endif
%_mandir/man1/ocamlbuild.1*

%files devel -f ocaml-files.devel

%changelog
