%def_with check
Name: ocaml-re
Version: 1.11.0
Release: alt2
Summary: A regular expression library for OCaml
License: LGPLv2.1 with OCaml-LGPL-linking-exception
Url: https://github.com/ocaml/ocaml-re
Source0: ocaml-re-%version.tar
Patch0: %name-%version-alt.patch
Group: Development/ML
BuildRequires: ocaml
BuildRequires: dune
%if_with check
BuildRequires: ocaml-ounit-devel
%endif

%description
A pure OCaml regular expression library. Supports Perl-style regular
expressions, Posix extended regular expressions, Emacs-style regular
expressions, and shell-style file globbing.  It is also possible to
build regular expressions by combining simpler regular expressions.
There is also a subset of the PCRE interface available in the Re.pcre
library.

%package devel
Summary: Development files for %name
Requires: %name = %EVR
Group: Development/ML

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup
%patch0 -p1
# set version in source code, 
echo "(version %version)" >>dune-project
sed -i "1a version: \"%version\"" re.opam

%build
%dune_build -p re

%install
%dune_install

%check 
sed -si 's,oUnit,ounit2,' lib_test/fort_unit/dune
%dune_check -p re

%files -f ocaml-files.runtime
%doc CHANGES.md README.md

%files devel -f ocaml-files.devel

%changelog
