%global pkgname react
%define ocamlsitelib %_libdir/ocaml
%define pkgsitelib %ocamlsitelib/%pkgname
%define ocamlstublib %_libdir/ocaml/stublibs/

Name: ocaml-%pkgname
Version: 1.2.2
Release: alt4
Summary: OCaml module for Functional Reactive Programming (FRP)
License: BSD
Group: Development/ML
Url: https://erratique.ch/software/react
VCS: https://github.com/dbuenzli/react
Source: %name-%version.tar
BuildPreReq: rpm-build-ocaml >= 1.6
BuildRequires: ocaml ocaml-ocamlbuild ocaml-findlib-devel opam ocaml-topkg-devel

%description
React is an OCaml module for functional reactive programming (FRP).
It provides support to program with time varying values : applicative
events and signals. React doesn't define any primitive event or signal,
this lets the client chooses the concrete timeline.

React is made of a single, independent, module and distributed under
the new BSD license.

Given an absolute notion of time Rtime helps you to manage a timeline
and provides time stamp events, delayed events and delayed signals.

%package devel
Summary: OCaml module for Functional Reactive Programming (FRP)
Group: Development/ML
Requires: %name = %EVR
%description devel
React is an OCaml module for functional reactive programming (FRP).
It provides support to program with time varying values : applicative
events and signals. React doesn't define any primitive event or signal,
this lets the client chooses the concrete timeline.

React is made of a single, independent, module and distributed under
the new BSD license.

Given an absolute notion of time Rtime helps you to manage a timeline
and provides time stamp events, delayed events and delayed signals.

%prep
%setup 

%build
sed -i 's,%%%%VERSION_NUM%%%%,%version,g' pkg/META
ocaml pkg/pkg.ml build

%install
opam-installer --prefix=%buildroot%prefix --libdir=%buildroot%_libdir/ocaml

%ocaml_find_files

%files -f ocaml-files.runtime

%files devel -f ocaml-files.devel

%changelog
