%def_enable snapshot
%define ver_major 0.8
%define xdg_name org.gnome.OCRFeeder

Name: ocrfeeder
Version: %ver_major.5
Release: alt3

Summary: OCRFeeder is a document layout analysis and optical character recognition system
Group: Graphics
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/OCRFeeder

BuildArch: noarch

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch: ocrfeeder-0.8.3-alt-configure.patch

Requires: python3-module-%name = %EVR
Requires: unpaper
# works best with Russian
Requires: tesseract tesseract-langpack-en tesseract-langpack-ru
#Requires: gocr
#Requires: ocrad
#Requires: cuneiform

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: intltool yelp-tools
BuildRequires: python3-devel python3-module-pygobject3-devel
BuildRequires: typelib(Gtk) = 3.0 typelib(GooCanvas) = 2.0
BuildRequires: python3(imp) python3(enchant) python3-module-Pillow
BuildRequires: python3-module-Reportlab python3-module-odfpy
BuildRequires: python3-module-sane

%description
OCRFeeder is a document layout analysis and optical character
recognition system. Given the images it will automatically outline its
contents, distinguish between what's graphics and text and perform OCR
over the latter. It generates multiple formats being its main one ODT.

%package -n python3-module-%name
Summary: Supplemental module for OCRFeeder
Group: Development/Python3
BuildArch: noarch
Requires: typelib(Gtk) = 3.0
Requires: typelib(GooCanvas) = 2.0

%description -n python3-module-%name
%summary

This package provides supplemental module for %name.

%prep
%setup
%patch -b .python

%build
export PYTHON=%__python3
%autoreconf
%configure PYTHON=%__python3
%make_build

%install
%makeinstall_std
%find_lang --with-gnome %name

%files -f ocrfeeder.lang
%_bindir/%name
%_bindir/%name-cli
%_desktopdir/%xdg_name.desktop
%_datadir/%name
%_man1dir/%name.1.*
%_man1dir/%name-cli.1.*
%_iconsdir/hicolor/*/*/%xdg_name.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS README TRANSLATORS NEWS

%files -n python3-module-%name
%python3_sitelibdir/ocrfeeder

%changelog
