# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed,unresolved=relaxed,rpath=relaxed

%ifarch x86_64
%def_with cuda
%else
%def_without cuda
%endif
%def_with vulkan

Name: ollama
Version: 0.12.11
Release: alt1
Summary: Get up and running with large language models
License: MIT
Group: Sciences/Computer science
Url: https://ollama.com
Vcs: https://github.com/ollama/ollama
%if_with cuda
# https://bugzilla.altlinux.org/52911
%filter_from_requires /(libcudart\.so\.12)/d
%filter_from_requires /debug64(libcuda\.so\.1)/d
Requires: ollama-cuda = %EVR
%endif
%if_with vulkan
Requires: %name-vulkan = %EVR
%endif
Requires: ollama-cpu = %EVR

ExcludeArch: %ix86
Source: %name-%version.tar
Source3: ollama-user.conf

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-systemd
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: golang
BuildRequires: look
BuildRequires: patchelf
%if_with cuda
BuildRequires: gcc12-c++
BuildRequires: nvidia-cuda-devel-static
%endif
%if_with vulkan
BuildRequires: glslc
BuildRequires: libvulkan-devel
%endif
%{?!_without_check:%{?!_disable_check:
BuildRequires: curl
}}

%description
%summary.
Run OpenAI gpt-oss, DeepSeek-R1, Gemma 3, Llama 4, Mistral, Phi-4,
Qwen 3, and other models, locally.

This is a meta-package.

%package cpu
Summary: The main ollama package with CPU runner
Group: Sciences/Computer science

%description cpu
%summary.

%package cuda
Summary: Ollama runner for NVIDIA GPU
Group: Sciences/Computer science
Requires: libnvidia-ptxjitcompiler
Requires: ollama-cpu = %EVR

%description cuda
%summary.

%package vulkan
Summary: Ollama runner for GPU
Group: Sciences/Computer science
Requires: ollama-cpu = %EVR

%description vulkan
%summary.

%prep
%setup
sed -i '/PRE_INCLUDE_REGEXES/d' CMakeLists.txt

%build
%add_optflags -Wno-unused-function
export NVCC_PREPEND_FLAGS=-ccbin=g++-12
%cmake -DCMAKE_CUDA_ARCHITECTURES='52-virtual;80-virtual' \
       -DGGML_BACKEND_DIR=%_libexecdir/ollama
%cmake_build
go build -v \
	-buildmode=pie \
	-ldflags="
		-X=github.com/ollama/ollama/version.Version=%version
		-X=github.com/ollama/ollama/server.mode=release
	"
find -type f -perm -1 -ls

%install
%cmake_install
install -Dp ollama %buildroot%_bindir/ollama
install -Dpm644 %SOURCE3 %buildroot%_sysusersdir/%name.conf
# HTTP server on 127.0.0.1:11434
install -Dpm644 .gear/%name.service -t %buildroot%_unitdir
mkdir -p %buildroot%_localstatedir/%name
install -Dpm644 models-list.txt tags-list.txt -t %buildroot%_datadir/ollama
install -Dpm644 .gear/completions %buildroot%_datadir/bash-completion/completions/ollama
# Add a RPATH to bypass lib.req false positive error.
find %buildroot%_libexecdir/ollama -name 'libggml-*.so' |
	xargs -trn1 patchelf --set-rpath %_libexecdir/ollama

%check
( ! cuobjdump --list-elf %buildroot%_libexecdir/ollama/libggml-cuda.so | grep -F -v -e .cubin )
( ! cuobjdump --list-ptx %buildroot%_libexecdir/ollama/libggml-cuda.so | grep -F -v -e .sm_80.ptx -e .sm_52.ptx )
cat /proc/loadavg
go test -v ./...
%buildroot%_bindir/ollama --version | grep -Fx 'Warning: client version is %version'
ldd %buildroot%_bindir/ollama
%buildroot%_bindir/ollama serve &
sleep 1
curl -sSf http://127.0.0.1:11434/api/version | grep '"version":"%version"'
curl -sSf http://127.0.0.1:11434/api/tags
curl -sSf http://127.0.0.1:11434/api/ps
kill %%?ollama

%pre cpu
%sysusers_create_package %name %SOURCE3

%post cpu
# We need to restart the server after all backends are installed, not in the
# middle of installs to avoid loading wrong DSO. But, just installing/removing
# a GPU backend won't trigger server restart. Upgrading a GPU backend will
# trigger the server restart via strict dependence on CPU backend.
%post_systemd_postponed %name.service

%preun cpu
%preun_systemd %name.service

%files

%files cpu
%define _customdocdir %_docdir/%name
%doc LICENSE README.md docs SECURITY.md
%_bindir/ollama
%_datadir/ollama
%_datadir/bash-completion/completions/ollama
%_unitdir/%name.service
%_sysusersdir/%name.conf
%dir %_libexecdir/ollama
%_libexecdir/ollama/libggml-base.so
%_libexecdir/ollama/libggml-cpu*.so
%attr(-,ollama,ollama) %dir %_localstatedir/%name

%if_with cuda
%files cuda
%_libexecdir/ollama/libggml-cuda.so
%endif

%if_with vulkan
%files vulkan
%_libexecdir/ollama/libggml-vulkan.so
%endif

%changelog
