%define _unpackaged_files_terminate_build 1

%define Name iSCSI
%define bname iscsi

Name: open-%bname
Version: 2.1.10
License: GPL-2.0-or-later
Release: alt1
Summary: Utils to operate with %Name
Group: System/Kernel and hardware
URL: http://%name.org
Source: %name-%version.tar
Source2: open-iscsi.init
Patch: %name-%version-%release.patch
Conflicts: linux-iscsi
Provides: iscsi-initiator-utils = 6.%version-%release

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson >= 0.54.0
BuildRequires: rpm-macros-systemd
BuildRequires: libmount-devel
BuildRequires: libkmod-devel
BuildRequires: libssl-devel
BuildRequires: libsystemd-devel
BuildRequires: libisns-devel

%description
The Open-iSCSI project is a high-performance, transport independent,
multi-platform implementation of RFC3720 iSCSI.

%package iscsiuio
Summary: Userspace configuration daemon required for some iSCSI hardware
Group: System/Kernel and hardware
License: BSD
Requires: %name = %version-%release

%description iscsiuio
The iscsiuio configuration daemon provides network configuration help
for some iSCSI offload hardware.

%package -n libopeniscsiusr
Summary: library providing access to Open-iSCSI initiator functionality
Group: System/Libraries
License: BSD

%description -n libopeniscsiusr
The libopeniscsiusr library provides a C API for access to the Open-iSCSI
initiator. It is used by the Open-iSCSI command line tools.

%package -n libopeniscsiusr-devel
Summary: Development files for libopeniscsiusr
Group: Development/C
Requires: libopeniscsiusr = %EVR

%description -n libopeniscsiusr-devel
The libopeniscsiusr-devel package contains libraries and header files for
developing applications that use libopeniscsiusr.

%prep
%setup
%patch -p1

%build
%meson \
    -Dsystemddir=%_systemd_util_dir \
    -Dhomedir=%_sysconfdir/%bname \
    -Ddbroot=%_sharedstatedir/%bname \
    -Drulesdir=%_udevrulesdir \
    -Discsi_sbindir=/sbin

%meson_build

%install
%meson_install

install -D -m 0755 %SOURCE2 %buildroot%_initdir/%name
mkdir -p %buildroot%_sharedstatedir/%bname/{nodes,send_targets,static,isns,slp,ifaces}
# create an empty initiatorname file, as a package place holder
echo > %buildroot%_sysconfdir/%bname/initiatorname.iscsi

install -d %buildroot%_tmpfilesdir
install -pm 644 etc/systemd/iscsi.tmpfiles %buildroot%_tmpfilesdir/%bname.conf

ln -s iscsid.service %buildroot%_unitdir/open-iscsi.service

%post
%tmpfiles_create %_tmpfilesdir/%bname.conf
if [ ! -f /etc/%bname/initiatorname.iscsi ] ; then
    /sbin/iscsi-gen-initiatorname
fi
%post_service %name

%preun
%preun_service %name

%post iscsiuio
%post_service iscsiuio

%preun iscsiuio
%preun_service iscsiuio

%files
%doc README THANKS etc/iface.example
%dir %_sysconfdir/%bname
%attr(0600,root,root) %config(noreplace) %_sysconfdir/%bname/%{bname}d.conf
%ghost %_sysconfdir/%bname/initiatorname.iscsi
%_sharedstatedir/%bname
%_initdir/*
%_tmpfilesdir/*
%_systemdgeneratordir/ibft-rule-generator
%_udevrulesdir/50-iscsi-firmware-login.rules
%_unitdir/*
%exclude %_unitdir/iscsiuio.*
/sbin/*
%exclude /sbin/iscsiuio
%exclude /sbin/brcm_iscsiuio
%_man8dir/*
%exclude %_man8dir/iscsiuio.8.*

%files iscsiuio
/sbin/iscsiuio
/sbin/brcm_iscsiuio
%_unitdir/iscsiuio.*
%config(noreplace) %_logrotatedir/iscsiuiolog
%_man8dir/iscsiuio.8.*

%files -n libopeniscsiusr
%_libdir/libopeniscsiusr.so.*

%files -n libopeniscsiusr-devel
%_libdir/libopeniscsiusr.so
%_includedir/*
%_pkgconfigdir/libopeniscsiusr.pc
%_man3dir/*

%changelog
