%define rname OpenEXR
%define libsover 30
Name: openexr
Version: 3.1.5
Release: alt2.2

%define _cmake__builddir BUILD
%define common %name%libsover-common
%define libopenexr libopenexr%libsover
%define libiex libiex%libsover
%define libilmthread libilmthread%libsover
%define libopenexrcore libopenexrcore%libsover
%define libopenexrutil libopenexrutil%libsover

Summary: A high-dynamic-range image file library
License: BSD-3-Clause
Group: System/Libraries
URL: http://www.openexr.org/

Provides: %rname = %version-%release
Obsoletes: %rname < %version-%release
Provides: %name-utils = %version-%release
Obsoletes: %name-utils < %version-%release

Source: %name-%version.tar

BuildRequires: gcc-c++ glibc-devel zlib-devel
BuildRequires: imath-devel
BuildRequires: python3-module-imath
BuildRequires: cmake

%define descr The OpenEXR project provides the specification and reference \
implementation of the EXR file format, the professional-grade \
image storage format of the motion picture industry. \
\
The purpose of EXR format is to accurately and efficiently represent \
high-dynamic-range scene-linear image data and associated metadata, \
with strong support for multi-part, multi-channel use cases. \
\
OpenEXR is widely used in host application software where accuracy is critical, \
such as photorealistic rendering, texture access, image compositing, \
deep compositing, and DI.

%description
%descr

%package -n %common
Group: System/Configuration/Other
Summary: Common empty package for %name
BuildArch: noarch

%description -n %common
Common empty package for %name

%package -n %libopenexr
Summary: %rname library
Group: System/Libraries

%description -n %libopenexr
%descr

%package devel
Summary: Headers for developing programs that will use OpenEXR
Group: Development/Other
Provides: ilmbase-devel = %version
Obsoletes: ilmbase-devel < %version
Requires: imath-devel
%description devel
%descr

This package contains the static libraries and header files needed for
developing applications with OpenEXR

%package -n %libiex
Summary: libIex %rname library
Group: System/Libraries

%description -n %libiex
%descr

%package -n %libilmthread
Summary: libIlmThread %rname library
Group: System/Libraries

%description -n %libilmthread
%descr

%package -n %libopenexrcore
Summary: libOpenEXRCore %rname library
Group: System/Libraries

%description -n %libopenexrcore
%descr

%package -n %libopenexrutil
Summary: libOpenEXRUtil %rname library
Group: System/Libraries

%description -n %libopenexrutil
%descr

%prep
%setup -n %name-%version

%build
%ifarch %e2k
%add_optflags -mno-avx -mno-f16c
%endif
%cmake
%cmake_build

%install
make -C BUILD install DESTDIR=%buildroot CMAKE_MODULE_PATH=%_includedir/Imath

%files -n %common
%doc *.md
%_docdir/%rname/examples

%files
%_bindir/*

%files -n %libopenexr
%_libdir/libOpenEXR-*.so.%libsover
%_libdir/libOpenEXR-*.so.%libsover.*

%files devel
%_libdir/lib*.so
%_includedir/OpenEXR/*
%_pkgconfigdir/OpenEXR.pc
%_libdir/cmake/OpenEXR/*.cmake

%files -n %libiex
%_libdir/libIex*.so.%libsover
%_libdir/libIex*.so.%libsover.*

%files -n %libilmthread
%_libdir/libIlmThread*.so.%libsover
%_libdir/libIlmThread*.so.%libsover.*

%files -n %libopenexrcore
%_libdir/libOpenEXRCore*.so.%libsover
%_libdir/libOpenEXRCore*.so.%libsover.*

%files -n %libopenexrutil
%_libdir/libOpenEXRUtil*.so.%libsover
%_libdir/libOpenEXRUtil*.so.%libsover.*

%changelog
