#define udapl 1
#define static 1
%define thread 1

# Build examples package only once
%ifndef udapl
%ifndef thread
%define examples 1
%endif
%endif

%ifdef udapl
%define udaplpkg openmpi-udapl
%define udaplarg --with-udapl
%else
%define udaplpkg openmpi
%define udaplarg --without-udapl
%endif

%ifdef thread
%define threadpkg %udaplpkg-threads
%define threadarg --with-threads=posix --enable-mpi-threads --enable-progress-threads --enable-ft-thread
%else
%define threadpkg %udaplpkg
%define threadarg --without-threads --disable-ft-thread --disable-mpi-threads
%endif


%ifdef static
%define pkgname %threadpkg-static
%define staticarg --enable-static --disable-shared
%else
%define pkgname %threadpkg
%define staticarg --disable-static
%endif

%define arguments %udaplarg %threadarg %staticarg

Name: openmpi
#pkgname

Version: 2.0.1
Release: alt9

%define mpi_prefix %_libdir/%name
%define mpi_sysconfdir %_sysconfdir/%name

Summary: A powerful implementation of MPI/SHMEM
License: BSD
Group: Development/Other
Url: http://www.open-mpi.org/

Packager: Denis Pynkin <dans@altlinux.ru>
Source:  openmpi-%version.tar
#Source1: MPI_Status_c2f.3

#Patch0: openmpi-%version-%release.patch
#Patch1: openmpi-arm-%version.patch

BuildPreReq: rpm-macros-mpi-selector rpm-macros-valgrind
Requires(post,preun): mpi-selector


%ifdef static
BuildPreReq: libibverbs-devel-static >= 1.1.2
%endif

%ifdef udapl
%ifdef static
BuildPreReq: libdapl-devel-static libstdc++-devel-static
%endif
Requires: libdapl >= 1.2.12
BuildPreReq: libdapl-devel
%endif

%ifdef thread
BuildPreReq: glibc-pthread
%endif

Requires: libibverbs >= 1.1.2
BuildPreReq: /proc flex gcc-c++ gcc-fortran
BuildPreReq: rdma-core-devel
%ifarch %valgrind_arches
BuildPreReq: valgrind-devel
%endif
BuildPreReq: libiberty-devel
%ifnarch %arm
BuildRequires: libnuma-devel
%endif

%package devel
Summary: Development part of %name
Group: Development/Other

Requires: %name = %version-%release
Requires: gcc-c++ gcc-fortran
Requires: rdma-core-devel
%ifnarch %arm
Requires: libnuma-devel
%endif

%ifdef udapl
Requires: libdapl-devel
%endif


%ifdef examples
%package %name-examples
Summary: Generic examples for %name.
Group: Development/Other
BuildArch: noarch

%description %name-examples
Examples comming with upstream sources tarball.
%endif

%description
Open MPI is an open source implementation of the Message Passing
Interface specification (http://www.mpi-forum.org/) developed and
maintained by a consortium of research, academic, and industry
partners.

Open MPI also includes an implementation of the OpenSHMEM parallel
programming API (http://www.openshmem.org/).  OpenSHMEM is a
Partitioned Global Address Space (PGAS) abstraction layer, which
provides fast inter-process communication using one-sided
communication techniques.

%description devel
Package for development with Open MPI/SHMEM

%prep
%setup -q -n openmpi-%version
#__cp -f SOURCE1 ompi/mpi/man/man3/
#patch0 -p1
#patch1 -p1

%build
CFLAGS+=" %optflags -D_FORTIFY_SOURCE=2"
CXXFLAGS+=" %optflags"
LDFLAGS+="-Wl,-R%mpi_prefix/lib/openmpi:%mpi_prefix/lib"
echo="/bin/echo"
export CFLAGS CXXFLAGS LDFLAGS echo

#autoreconf
./autogen.pl

function buildIt() {
	./configure $* \
			--enable-mpi-f77 \
			--enable-mpi-f90 \
			--prefix=%mpi_prefix \
			--with-ft=cr \
			--with-verbs \
			--without-tm \
			--sysconfdir=%mpi_sysconfdir \
			--bindir=%mpi_prefix/bin \
			--libdir=%mpi_prefix/lib \
			--datadir=%mpi_prefix/data \
			--includedir=%mpi_prefix/include \
			--mandir=%mpi_prefix/man \
			--docdir=%_docdir/%name-%version \
			--with-gnu-ld \
			--with-wrapper-ldflags="-Wl,-rpath=%mpi_prefix/lib"

#			--with-wrapper-ldflags="-Wl,--no-as-needed,-rpath=%mpi_prefix/lib"

#TODO: --with-cuda

	%make_build
}

buildIt %arguments

%install
echo="/bin/echo"
export echo

%make_install DESTDIR=%buildroot install

#ln -s ompi-restart %buildroot%_libdir/%name/bin/orte-restart
#ln -s ompi-checkpoint %buildroot%_libdir/%name/bin/orte-checkpoint

# Avoid fail during man pages compression
#rm -f %buildroot%_libdir/%name/man/man1/mpiCC.1
#rm -f %buildroot%_libdir/%name/man/man1/orteCC.1

#ln -s mpic++.1.gz %buildroot%_libdir/%name/man/man1/mpiCC.1.gz
#ln -s mpic++.1.gz %buildroot%_libdir/%name/man/man1/orteCC.1.gz

%find_lang %name

echo -e "btl = tcp,self\n" >> %buildroot%mpi_sysconfdir/openmpi-mca-params.conf

cat>%buildroot/%mpi_prefix/bin/mpivars.sh<<EOF
if ! echo \$PATH | grep -q %mpi_prefix/bin ; then
    PATH=%mpi_prefix/bin:\$PATH
    export PATH
fi

if ! echo \$LD_LIBRARY_PATH | grep -q %mpi_prefix/lib ; then
    LD_LIBRARY_PATH=%mpi_prefix/lib\${LD_LIBRARY_PATH:+:\$LD_LIBRARY_PATH}
    export LD_LIBRARY_PATH
fi

if ! echo \$MANPATH | grep -q %mpi_prefix/man ; then
    MANPATH=%mpi_prefix/man:\$MANPATH
    export MANPATH
fi
EOF

cat >%buildroot%mpi_prefix/bin/mpivars.csh <<EOF
if (\$?path) then
    if ( "\${path}" !~ *%mpi_prefix/bin* ) then
	set path = ( %mpi_prefix/bin \$path )
    endif
else
    set path = ( %mpi_prefix/bin )
endif

if (\$?LD_LIBRARY_PATH) then
    if ( "\$LD_LIBRARY_PATH" !~ *%mpi_prefix/lib* ) then
	setenv LD_LIBRARY_PATH %mpi_prefix/lib:\$LD_LIBRARY_PATH
    endif
else
    setenv LD_LIBRARY_PATH %mpi_prefix/lib
endif

if (\$?MANPATH) then
    if ( "\$MANPATH" !~ *%mpi_prefix/man* ) then
	setenv MANPATH %mpi_prefix/man:\$MANPATH
    endif
else
    setenv MANPATH %mpi_prefix/man
endif
EOF

%post
%post_mpi_selector %name %mpi_prefix/bin

%preun
%preun_mpi_selector %name

%files -f %name.lang
%doc AUTHORS LICENSE NEWS README VERSION 

%dir %mpi_prefix

%dir %mpi_prefix/bin

%mpi_prefix/bin/mpivars.*
%mpi_prefix/bin/mpirun
%mpi_prefix/bin/ompi_info
%mpi_prefix/bin/orted
%mpi_prefix/bin/orterun
%mpi_prefix/bin/mpiexec

%mpi_prefix/bin/ompi-*
%mpi_prefix/bin/orte-*
#mpi_prefix/bin/opal-*

%mpi_prefix/bin/oshmem_info
%mpi_prefix/bin/oshrun
%mpi_prefix/bin/shmemrun

%dir %mpi_prefix/lib
%dir %mpi_prefix/lib/openmpi
%mpi_prefix/lib/openmpi/*.so

%ifdef static
%mpi_prefix/lib/lib*
%exclude %mpi_prefix/lib/libvt*
%else
%mpi_prefix/lib/lib*.so.*
%endif

%dir %mpi_sysconfdir
%config(noreplace) %mpi_sysconfdir/*

%dir %mpi_prefix/man
%mpi_prefix/man/man1
%mpi_prefix/man/man7
%mpi_prefix/data

%files devel
%mpi_prefix/bin/opal_wrapper
%mpi_prefix/bin/mpic++
%mpi_prefix/bin/mpicc
%mpi_prefix/bin/mpiCC
%mpi_prefix/bin/mpicxx
%mpi_prefix/bin/mpif77
%mpi_prefix/bin/mpif90
%mpi_prefix/bin/mpifort
%mpi_prefix/bin/oshcc
%mpi_prefix/bin/oshfort
%mpi_prefix/bin/shmemcc
%mpi_prefix/bin/shmemfort

#mpi_prefix/bin/orte_wrapper_script
#mpi_prefix/bin/orteCC
#mpi_prefix/bin/ortec++
%mpi_prefix/bin/ortecc

%dir %mpi_prefix/include
%mpi_prefix/include/*.h
%dir %mpi_prefix/include/openmpi
%mpi_prefix/include/openmpi/*

%dir %mpi_prefix/include/openshmem
%mpi_prefix/include/openshmem/*

%dir %mpi_prefix/include/mpp
%mpi_prefix/include/mpp/*
%mpi_prefix/include/shmem.fh

%mpi_prefix/man/man3

%mpi_prefix/lib/*.mod

%mpi_prefix/lib/pkgconfig/*

%ifdef static
%mpi_prefix/lib/openmpi/*.a
%mpi_prefix/lib/libotf.a
%else
%mpi_prefix/lib/lib*.so
%mpi_prefix/lib/*.la
%mpi_prefix/lib/openmpi/*.la
%endif

%ifdef examples
%files %name-examples
%doc examples
%endif

%changelog
