%define _unpackaged_files_terminate_build 1
%define installdir %webserver_webappsdir/%name
%define otrs_user otrs

Name: otrs
Version: 6.0.38
Release: alt1

Summary: Open source Ticket Request System Community Edition
Group: Networking/WWW
License: GPL-3.0-only
Url: https://www.znuny.org/en

Source0: https://download.znuny.org/releases/znuny-%version.tar.bz2
Source1: README.ALT.rus
Source2: otrs-hold.conf
Source3: apache2.conf

BuildArch: noarch

BuildRequires(pre): rpm-macros-webserver-common rpm-macros-apache2 >= 3.9

Requires: webserver-common perl-CGI perl-DBI perl-DBD-mysql

# requires for start httpd2
Requires: perl-DateTime perl-Template

# is needed (found in /var/log/httpd2/error_log)
Requires: perl-Unicode-Collate perl-Moo

# hard requires by otrs.CheckModules.pl
Requires: perl-Archive-Tar perl-Archive-Zip perl-TimeDate perl-Net-DNS perl-YAML-LibYAML

# some of soft requires by otrs.CheckModules.pl
Requires: perl-Crypt-Eksblowfish perl-Crypt-SSLeay perl-JSON-XS perl-Mail-IMAPClient perl-IO-Socket-SSL perl-Text-CSV_XS perl-XML-LibXSLT perl-XML-Parser

# is needed for DBUpdate-to-6.pl
Requires: perl-CPAN-Meta

%add_findreq_skiplist */bin/*
%add_findreq_skiplist */Kernel/*
%add_findreq_skiplist */scripts/*
%add_findreq_skiplist */examples/*

%description
OTRS is an Open source Ticket Request System (also well known
as trouble ticket system) with many features to manage customer
telephone calls and e-mails. The system is built to allow your
support, sales, pre-sales, billing, internal IT, helpdesk, e.t.c.
departments to react quickly to inbound inquiries.

This is the ((OTRS)) Community Edition Fork by Znuny GmbH

%package apache2
Summary: Apache 2.x web-server configuration for %name
Group: Networking/WWW
Requires: %name = %version-%release, apache2, apache2-mod_perl perl-Apache-DBI
%description apache2
Apache 2.x web-server configuration for %name

%prep
%setup -n znuny-%version

%install
# install apache config
install -pD -m0644 %SOURCE3 %buildroot%_sysconfdir/httpd2/conf/addon.d/A.%name.conf

# install apt's hold file
install -pD -m0644 %SOURCE2 %buildroot%_sysconfdir/apt/apt.conf.d/%name-hold.conf

# install otrs
mkdir -p %buildroot%installdir
cp -rp * %buildroot%installdir/

#install docs
install -pD -m0644 %SOURCE1 README.ALT.rus

#replace '/opt/otrs' to '/var/www/webapps/otrs' in all files
find %buildroot%installdir -type f -exec sed -i -e "s/\/opt\/otrs/\/var\/www\/webapps\/otrs/g" {} \;

# remove files
find %buildroot%installdir -name *.spec -delete
find %buildroot%installdir -name *.conf -delete

#install default config
cp %buildroot%installdir/Kernel/Config.pm.dist %buildroot%installdir/Kernel/Config.pm
# cd %buildroot%installdir/Kernel/Config/
# for foo in *.dist; do cp $foo `basename $foo .dist`; done
cd %buildroot%installdir/var/cron/
for foo in *.dist; do cp $foo `basename $foo .dist`; done

# all needed files packaged from %%builddir
rm -f %buildroot%installdir/ARCHIVE
rm -f %buildroot%installdir/AUTHORS.md
rm -f %buildroot%installdir/CHANGES.md
rm -f %buildroot%installdir/CONTRIBUTING.md
rm -f %buildroot%installdir/COPYING
rm -f %buildroot%installdir/COPYING-Third-Party
rm -f %buildroot%installdir/INSTALL.md
rm -f %buildroot%installdir/README.md
rm -f %buildroot%installdir/SECURITY.md
rm -f %buildroot%installdir/UPDATING.md
rm -f %buildroot%installdir/Custom/README

%pre
if id %otrs_user >/dev/null 2>&1; then
    # update groups
    usermod -g %webserver_group %otrs_user
    # update home dir
    usermod -d %installdir %otrs_user
else
   %_sbindir/useradd -r  -g %webserver_group -c 'OTRS User' -d %installdir -s '/dev/null' %otrs_user >/dev/null 2>&1 ||:
fi

%post
cd %installdir/bin/
./otrs.SetPermissions.pl \
    --otrs-user=%otrs_user \
    --web-user=root \
    --otrs-group=%webserver_group \
    --web-group=%webserver_group \
    --skip-regex="Config.pm" \
    %installdir >/dev/null 2>&1
#./Cron.sh start %otrs_user >/dev/null 2>&1

%files
%doc AUTHORS.md
%doc CHANGES.md
%doc CONTRIBUTING.md
%doc COPYING
%doc COPYING-Third-Party
%doc INSTALL.md
%doc README.md
%doc README.ALT.rus
%doc SECURITY.md
%doc UPDATING.md
%doc Custom/README
%defattr(0775,root, %webserver_group)
%dir %installdir
%config(noreplace) %attr(0660,root,%webserver_group) %installdir/Kernel/Config.pm
#config(noreplace) %attr(0660,root,%webserver_group) %installdir/Kernel/Config/GenericAgent.pm
%installdir/Kernel
%installdir/bin
%installdir/scripts
%installdir/doc
%installdir/var
%installdir/i18n
%installdir/RELEASE

%config(noreplace) %attr(0644,root,root) %_sysconfdir/apt/apt.conf.d/%name-hold.conf

%files apache2
%config(noreplace) %attr(0644,root,root) %_sysconfdir/httpd2/conf/addon.d/A.%name.conf

%changelog
