Name: pam-config
Version: 1.9.1
Release: alt1

Summary: Systemwide PAM config files for Linux-PAM
License: GPLv2+
Group: System/Base
BuildArch: noarch

Source0: %name-%version.tar

Source2: pam_mktemp.control
Source3: system-auth.control
Source4: system-auth-chooser.in
Source5: system-policy.control
Source6: system-auth.filetrigger
Source7: system-policy.filetrigger
Source8: pam_access.control
Source9: pam_canonicalize_user.control

%define _pamdir %_sysconfdir/pam.d

Requires(pre,postun): %name-control = %version-%release
Requires: libpasswdqc >= 0:1.1.0-alt0.2
Requires: libcrypt >= 4.4.4
Requires: pam_tcb >= 1.1.0.1
Provides: %_pamdir, /etc/security
Provides: pam-common = %version-%release
Obsoletes: pam-common < %version-%release
Provides: pam0-config = %version-%release
Obsoletes: pam0-config < %version-%release
# Compatibility.
Provides: pam(system-auth), pam(system-auth-use_first_pass), pam(other)
# These requirements are optional.
%filter_from_requires /^PAM(pam_\(ccreds\|krb5\|ldap\|pkcs11\|winbind\)\.so)/d

# due to %_pamdir/other
Conflicts: pam < 0:0.75-alt21
# due to pam_mktemp.so
Conflicts: openssh-server < 0:4.6p1

BuildPreReq: rpm-macros-pam

%package control
Summary: Control rules for the systemwide PAM config files
Group: System/Base

%description
PAM (Pluggable Authentication Modules) is a system security tool
which allows system administrators to set authentication policy
without having to recompile programs which do authentication.

This package contains systemwide config files for Linux-PAM.

%description control
This package contains control rules for systemwide PAM config files.
See control(8) for details.

%prep
%setup

%build
template='%_sourcedir/system-auth-chooser.in'
for only in system-auth-*-only; do
	target="${only%%-only}"
	method="${target##*-}"
	[ "$method" != 'local' ] || continue
	base="${target%%-$method}"
	{
		echo '#%%PAM-1.0'
		for type in auth account password session; do
			grep -q "^$type" "$only" || continue
			sed -e "s/@TYPE@/$type/" \
			    -e "s/@BASE@/$base/" \
			    -e "s/@METHOD@/$method/" \
			    "$template"
		done
	} > "$target"
done

%install
mkdir -p %buildroot{%_pamdir,%_controldir,/etc/security}

cp -a * %buildroot%_pamdir/
chmod 644 %buildroot%_pamdir/*

for f in pam_access pam_canonicalize_user pam_mktemp system-auth system-policy; do
	install -pm755 %_sourcedir/$f.control %buildroot%_controldir/$f
done

for f in system-auth system-policy; do
	install -Dm0755 %_sourcedir/$f.filetrigger %buildroot%_rpmlibdir/$f.filetrigger
done

%trigger control -- pam-config < 1.9.1-alt1
# disable legacy pam_propperpwnam.so and enable pam_canonicalize_user.so
if grep -q '^[#[:space:]]*-\?auth\s\+\(optional\|required\)\s\+pam_propperpwnam\.so\s*$' "%_pamdir/system-auth-common"; then
	sed -i 's,^\([#[:space:]]*-\?auth\s\+\(optional\|required\)\s\+\)pam_propperpwnam\.so\s*$,\1pam_canonicalize_user.so,' "%_pamdir/system-auth-common"
else
# default state for pam_canonicalize_user.so
	grep -q '^[#[:space:]]*-\?auth\s\+\(optional\|required\)\s\+pam_canonicalize_user\.so\s*$' "%_pamdir/system-auth-common" ||
		sed -i '/^#%%PAM-1\.0$/a #auth\t\trequired\tpam_canonicalize_user.so' "%_pamdir/system-auth-common"
fi

%pre
%pre_control pam_mktemp
%pre_control pam_access
%pre_control pam_canonicalize_user
for f in %_pamdir/system-auth %_pamdir/system-auth-use_first_pass %_pamdir/system-policy; do
	if [ -f "$f" -a ! -L "$f" ]; then
		mv -f "$f" "$f-local" &&
		ln -f "$f-local" "$f-local.rpmsave" &&
		touch "/var/run/${f##*/}-local.update" &&
		ln -s "${f##*/}-local" "$f" ||:
	fi
done
%pre_control system-auth
if [ -f "%_pamdir/system-policy" ]; then
	%pre_control system-policy
fi

%post
cd %_pamdir
for f in system-auth system-auth-use_first_pass system-policy; do
	if [ -f "/var/run/$f-local.update" -a -f "$f-local.rpmsave" ]; then
		[ -f "$f-local.rpmnew" ] ||
			ln -f "$f-local" "$f-local.rpmnew" ||:
		mv -f "$f-local.rpmsave" "$f-local" &&
			rm -f "/var/run/$f-local.update" ||:
		cmp -s "$f-local" "$f-local.rpmnew" &&
			rm -f "$f-local.rpmnew" ||:
	fi
done
for f in system-auth system-policy; do
	if [ ! -f "$f" ]; then
		if [ -f "$f.rpmsave" ]; then
			cp -af "$f.rpmsave" "$f"
		elif [ -f "$f.rpmnew" ]; then
			cp -af "$f.rpmnew" "$f"
		fi
	fi
done
%post_control -s local system-auth
if [ $1 -ge 2 ]; then
	status_dir='/var/run/control'
	status_file="$status_dir/system-policy"
	[ -f "$status_file" ] || {
		mkdir -p "$status_dir"
		if [ "$(/usr/sbin/control system-auth)" = "local" ]; then
			echo local
		else
			echo remote
		fi > "$status_file"
	}
fi
%post_control -s local system-policy
%post_control -s enabled pam_mktemp
%post_control -s disabled pam_access
%post_control -s disabled pam_canonicalize_user

%triggerpostun -- pam <= 0:0.75-alt8
[ $2 -gt 0 ] || exit 0
cd %_pamdir
if [ ! -f system-auth ]; then
	if [ -f system-auth.rpmsave ]; then
		cp -pf system-auth.rpmsave system-auth
	elif [ -f system-auth.rpmnew ]; then
		cp -pf system-auth.rpmnew system-auth
	fi
fi

%files
%dir %_pamdir
%config %_pamdir/other
%config(noreplace) %_pamdir/system-auth-common
%config(noreplace) %_pamdir/*-local
%config(noreplace) %_pamdir/*-only
%config(noreplace) %_pamdir/*-ldap
%config(noreplace) %_pamdir/*-krb5
%config(noreplace) %_pamdir/*-krb5_ccreds
%config(noreplace) %_pamdir/*-multi
%config(noreplace) %_pamdir/*-pkcs11
%config(noreplace) %_pamdir/*-winbind
%config(noreplace) %_pamdir/*-remote
%config(noreplace) %_pamdir/common-login*
%_pamdir/system-auth
%_pamdir/system-auth-use_first_pass
%_pamdir/system-policy
%_rpmlibdir/system-auth.filetrigger
%_rpmlibdir/system-policy.filetrigger
/etc/security

%files control
%config %_controldir/*

%changelog
