%define optflags_lto -flto=thin

%define version_hi 2
%define version_mid 4
%define version_lo 0

# git log v%version_hi.%version_mid.%version_lo -1 --format=%cd --date=local
%define git_date Sun Jun 29 22:47:12 2025
# git rev-parse v%version_hi.%version_mid.%version_lo
%define git_hash e4af1c424451c6b65c5c387404315cef77e9901b

Name: pcsx2
Version: 2.4.0
Release: alt1

Summary: Playstation 2 console emulator
License: GPLv3 and LGPLv3
Group: Emulators

Url: http://%name.net/
Packager: Nazarov Denis <nenderus@altlinux.org>

ExclusiveArch: x86_64

# https://github.com/PCSX2/%name/archive/v%version/%name-%version.tar.gz
Source: %name-%version.tar

BuildRequires: bzlib-devel
BuildRequires: clang
BuildRequires: ctest
BuildRequires: extra-cmake-modules
BuildRequires: libGLU-devel
BuildRequires: libSDL3-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXcursor-devel
BuildRequires: libXdamage-devel
BuildRequires: libXdmcp-devel
BuildRequires: libXft-devel
BuildRequires: libXinerama-devel
BuildRequires: libXmu-devel
BuildRequires: libXrandr-devel
BuildRequires: libXtst-devel
BuildRequires: libaio-devel
BuildRequires: libalsa-devel
BuildRequires: libavformat-devel
BuildRequires: libbacktrace-devel
BuildRequires: libcurl-devel
BuildRequires: libdbus-devel
BuildRequires: libexpat-devel
BuildRequires: libffi-devel
BuildRequires: libidn2-devel
BuildRequires: libjpeg-devel
BuildRequires: libkddockwidgets-qt6-devel
BuildRequires: liblz4-devel
BuildRequires: liblzma-devel
BuildRequires: libpcap-devel
BuildRequires: libpcre2-devel
BuildRequires: libplutosvg-devel
BuildRequires: libplutovg-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libshaderc-devel
BuildRequires: libswresample-devel
BuildRequires: libswscale-devel
BuildRequires: libtiff-devel
BuildRequires: libudev-devel
BuildRequires: libwayland-egl-devel
BuildRequires: libwebp-devel
BuildRequires: libzstd-devel
BuildRequires: lld
BuildRequires: llvm
BuildRequires: qt6-declarative-devel
BuildRequires: qt6-tools-devel

%description
PCSX2 is an emulator for the playstation 2 video game console. It is written mostly in C++, some part are in C and x86 assembly.
There is still lot of on going work to improve compatibility & speed.

%prep
%setup

%build
%cmake \
	-DCMAKE_C_COMPILER:STRING=clang \
	-DCMAKE_CXX_COMPILER:STRING=clang++ \
	-DCMAKE_RANLIB:PATH=%_bindir/llvm-ranlib \
	-DCMAKE_AR:PATH=%_bindir/llvm-ar \
	-DCMAKE_NM:PATH=%_bindir/llvm-nm \
	-DCMAKE_EXE_LINKER_FLAGS:STRING="-fuse-ld=lld" \
	-DCMAKE_BUILD_TYPE:STRING="RelWithDebInfo" \
	-DCMAKE_DISABLE_PRECOMPILE_HEADERS:BOOL=TRUE \
	-DCMAKE_BUILD_PO:BOOL=TRUE \
	-DDISABLE_ADVANCE_SIMD:BOOL=TRUE \
	-DLTO_PCSX2_CORE:BOOL=TRUE \
	-DPACKAGE_MODE:BOOL=TRUE \
	-GNinja \
	-Wno-dev

echo "#define GIT_TAG \"v$(echo %version)\"
#define GIT_TAGGED_COMMIT 1
#define GIT_TAG_HI  $(echo %version_hi)
#define GIT_TAG_MID $(echo %version_mid)
#define GIT_TAG_LO  $(echo %version_lo)
#define GIT_REV \"v$(echo %version)\"
#define GIT_HASH \"$(echo %git_hash)\"
#define GIT_DATE \"$(echo %git_date)\"" > %_cmake__builddir/common/include/svnrev.h

%cmake_build

%install
%cmake_install
%__mkdir_p %buildroot{%_iconsdir/hicolor/64x64/apps,%_iconsdir/hicolor/512x512/apps,%_desktopdir}
%__install -Dp -m0644 %name-qt/resources/icons/AppIcon64.png %buildroot%_iconsdir/hicolor/64x64/apps/PCSX2.png
%__install -Dp -m0644 bin/resources/icons/AppIconLarge.png %buildroot%_iconsdir/hicolor/512x512/apps/PCSX2.png
%__install -Dp -m0644 .github/workflows/scripts/linux/%name-qt.desktop %buildroot%_desktopdir/%name-qt.desktop

%check
%ctest

%files
%doc bin/docs/*.pdf
%_bindir/%name-qt
%_desktopdir/%name-qt.desktop
%_datadir/PCSX2
%_iconsdir/hicolor/*/apps/PCSX2.png

%changelog
