Name: pdbv
Version: 2.0.11
Release: alt3
Summary: Pdbv output a HTML view of a RPM or dpkg database
License: %gpl2plus
Group: File tools
Url: http://gna.org/projects/pdbv
Packager: Eugeny A. Rostovtsev (REAL) <real@altlinux.org>

Source: http://download.gna.org/pdbv/2.x/2.0.11/pdbv-2.0.11.tar.gz

BuildRequires(pre): rpm-build-licenses
BuildPreReq: perl-Locale-gettext dpkg perl(Tie/IxHash.pm)
BuildPreReq: perl-Term-ANSIColor

%description
Pdbv output a HTML view of a RPM or dpkg database. Its modular design
allows easy addition of others package management database and export
format (as xml).

 Why using it:
 - it does not require lucid/gtk+/qt or other big libs.
 - it does not require a web server - but it can be used with a web
server, as any other html files.
 - it does not require a X server running, you can use a text mode
browser that support frames as links.
 - it does not require special privileges to access to the output. But
access can be restricted by using chmod/chown (filesystem) or .htaccess
(apache).
 - since output is generated by a cronjob, access to the output is as
fast as your computer is able to read/serve text files.

 Why not using it:
 - it's purpose is not to manage packages installed.
 - since output is generated by a cronjob, informations are dated, and
can be outdated if the database change very frequently. Note that with
the 2.x.x series, the cronjob should be hourly.

You can see demos at http://dl.gna.org/pdbv/demo_html/

%prep
%setup -n %name-%version

%build
PATH4SED=%buildroot%_sysconfdir
export PATH4SED
sed -i -e 's/\/etc/$PATH4SED/g' configure
sed -i -e 's/\/etc/$PATH4SED/g' Makefile
sed -i -e 's/\/etc/$PATH4SED/g' */Makefile
%configure \
	--prefix=%buildroot%prefix \
	--type=rpm
%make_build

%install
mkdir -pv %buildroot%_bindir
mkdir -pv %buildroot%_sysconfdir/%name
mkdir -pv %buildroot%_sysconfdir/cron.d
mkdir -pv %buildroot/var/www/%name
 
%make_install DESTDIR=%buildroot install

sed -i 's|%buildroot||g' \
	%buildroot%_sysconfdir/%name/htaccess \
	%buildroot%_sysconfdir/%name/pdbvrc

%find_lang --with-man %name

%files -f %name.lang
%_bindir/*
%_sysconfdir/%name
# omit cron file

%changelog
