# if debug isn't enabled, %%perl_vendor_build ignores %%optflags
%def_enable debug

Name: perl-AptPkg
Version: 0.1.26
Release: alt6

Summary: Perl interface to libapt-pkg
License: GPLv2+
Group: Development/Perl

URL: http://packages.debian.org/unstable/perl/libapt-pkg-perl
Source: libapt-pkg-perl-%version.tar
Patch: %name-%version-%release.patch

# Automatically added by buildreq on Wed Oct 12 2011
BuildRequires: gcc-c++ libapt-devel perl-devel
%{?!_without_test:%{?!_disable_test:BuildPreReq: apt}}

%description
A Perl interface to APT's libapt-pkg which provides modules
for configuration file/command line parsing, version comparison,
inspection of the binary package cache and source package details.

%prep
%setup -n libapt-pkg-perl-%version
%patch -p1
%{?!_without_test:%{?!_disable_test:cp -a /etc/apt/* t/cache/etc/}}

%build
# Needed by APT API:
%add_optflags -std=gnu++17

%ifarch %e2k
%remove_optflags -Wno-error
%endif

# To avoid some errors on API change:
%add_optflags -Werror=overloaded-virtual
# A style enforcement: always use the keyword, which helps to avoid API misuse
%add_optflags -Werror=suggest-override

%perl_vendor_build INC=-I%_includedir/rpm %{?!_without_test:%{?!_disable_test:||:}}

%install
%perl_vendor_install

%files
%doc	README debian/changelog examples
	%perl_vendor_archlib/AptPkg.pm
%dir	%perl_vendor_archlib/AptPkg
	%perl_vendor_archlib/AptPkg/*.pm
%doc	%perl_vendor_archlib/AptPkg/*.pod
%dir	%perl_vendor_autolib/AptPkg
	%perl_vendor_autolib/AptPkg/AptPkg.so

%changelog
