%define real_name Crypt-SMIME

Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-build-licenses
BuildRequires: perl-podlators
# END SourceDeps(oneline)
BuildRequires: openssl
Name:           perl-%real_name
Version:        0.30
Release:        alt1
Summary:        S/MIME message signing, verification, encryption and decryption
License:        %perl_license
URL:            https://metacpan.org/release/%real_name
Source0:        https://cpan.metacpan.org/modules/by-module/Crypt/%real_name-%{version}.tar
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  libssl-devel
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/CChecker.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(XSLoader.pm)
# Tests
BuildRequires:  openssl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/PkgConfig.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Taint/Util.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Taint.pm)
BuildRequires:  perl(Test/More.pm)

#Add a test sub package.
%{?perl_default_subpackage_tests}

%description
This module provides a class for handling S/MIME messages. It can sign,
verify, encrypt and decrypt messages. It requires libcrypto
(http://www.openssl.org) to work.

%prep
%setup -q -n Crypt-SMIME-%{version}
# As part of the rpm process we generate some .list files which
# then cause t/manifest.t to fail.
echo '\.list$' >> MANIFEST.SKIP
echo '\.perl.req$' >> MANIFEST.SKIP

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/auto/*
%perl_vendor_archlib/Crypt*

%changelog
