## SPEC file for Perl module HTTP::BrowserDetect

%define real_name HTTP-BrowserDetect
%define _unpackaged_files_terminate_build 1

Name: perl-HTTP-BrowserDetect
Version: 3.40
Release: alt1

Summary: determine Web browser from an HTTP user agent string

License: %perl_license
Group: Development/Perl

URL: http://search.cpan.org/dist/HTTP-BrowserDetect/

Packager: Nikolay A. Fetisov <naf@altlinux.ru>

Source: %real_name-%version.tar

BuildArch: noarch

BuildRequires(pre): perl-devel rpm-build-licenses

# Automatically added by buildreq on Sat Nov 06 2021
# optimized out: libgpg-error perl perl-Algorithm-Diff perl-CPAN-Meta-Requirements perl-Clone-Choose perl-Devel-StackTrace perl-Encode perl-JSON-PP perl-Parse-CPAN-Meta perl-Text-Diff perl-devel perl-parent python3-base sh4
BuildRequires: perl-CPAN-Meta perl-Clone perl-Module-Runtime perl-Path-Tiny perl-Test-Differences perl-Test-NoWarnings perl-Test-Warnings

%description
Perl module HTTP::BrowserDetect does a number of tests on an HTTP
user agent string. The results of these tests are available via
methods of the object.

This module was originally based upon the JavaScript browser
detection code available at
http://www.mozilla.org/docs/web-developer/sniffer/browser_type.html .


%prep
%setup -q -n %real_name-%version

# Tests runs fine with our List::Util 1.46_02
sed -e '/List::Util/ s/1\.49/1.46/' -i t/00-report-prereqs.dd
sed -e '/List::Util/ s/1\.49/1.46/' -i t/01-detect.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTORS TODO Changes README.md examples
%perl_vendor_privlib/HTTP/BrowserDetect*

%changelog
