%define _unpackaged_files_terminate_build 1
%global oname IO-Async

Name: perl-%oname
Version: 0.802
Release: alt3

Summary: Asynchronous event-driven programming
Group: Development/Perl
License: perl

Url: %CPAN %oname
# https://cpan.metacpan.org/authors/id/P/PE/PEVANS/%oname-%version.tar.gz
Source: %oname-%version.tar

BuildArch: noarch
BuildRequires: /proc perl(IO/Socket/IP.pm) perl(Module/Build.pm) perl(Future.pm) perl(Future/Utils.pm) perl-devel perl(Struct/Dumb.pm) perl(Future/IO.pm)
# tests
BuildRequires: perl(Test/Refcount.pm) perl(Test/Fatal.pm) perl(Test/Future/IO/Impl.pm) perl(Test/Identity.pm) perl(Test/Metrics/Any.pm) perl(experimental.pm)

%add_findreq_skiplist */IO/Async/MergePoint.pm

%description
%summary

%package -n perl-Future-IO-Impl-IOAsync
Summary: Future::IO Implementation using IO::Async
Group: Development/Perl
Requires: %name = %EVR

%description -n perl-Future-IO-Impl-IOAsync
Future::IO Implementation using IO::Async

%package tests
Summary: Test modules for IO::Async
Group: Development/Perl
Requires: %name = %EVR

%description tests

This package contains tests for %name.

%prep
%setup -q -n %oname-%version

# broken on LoongArch and ppc64le, but ifarch did not expand here :(
case `uname -m` in
  ppc64*|loongarch*)
  rm -f t/70future-io.t
  ;;
esac

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/IO/Async*
%exclude %perl_vendor_privlib/IO/Async/LoopTests.pm
%exclude %perl_vendor_privlib/IO/Async/Test.pm

%files -n perl-Future-IO-Impl-IOAsync
%perl_vendor_privlib/Future/IO/Impl/IOAsync.pm

%files tests
%perl_vendor_privlib/IO/Async/LoopTests.pm
%perl_vendor_privlib/IO/Async/Test.pm

%changelog
