%filter_from_requires /^perl.utf8_heavy.pl.$/d
%define _unpackaged_files_terminate_build 1
Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Lexical-SealRequireHints
Version:        0.012
Release:        alt1
Summary:        Prevent leakage of lexical hints
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Lexical-SealRequireHints
Source0:        http://www.cpan.org/authors/id/Z/ZE/ZEFRAM/Lexical-SealRequireHints-%{version}.tar.gz
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/CBuilder.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests
BuildRequires:  perl(Test/More.pm)
# Optional tests
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(Thread/Semaphore.pm)
BuildRequires:  perl(threads.pm)
BuildRequires:  perl(threads/shared.pm)
Conflicts:      perl(B:Hooks/OP/Check.pm) < 0.190


Source44: import.info

%description
This module works around two historical bugs in Perl's handling of the %^H
(lexical hints) variable. One bug causes lexical state in one file to leak
into another that is required/used from it. This bug, [perl #68590], was
present from Perl 5.6 up to Perl 5.10, fixed in Perl 5.11.0. The second bug
causes lexical state (normally a blank %^H once the first bug is fixed) to
leak outwards from utf8.pm, if it is automatically loaded during Unicode
regular expression matching, into whatever source is compiling at the time
of the regexp match. This bug, [perl #73174], was present from Perl 5.8.7
up to Perl 5.11.5, fixed in Perl 5.12.0.

%prep
%setup -q -n Lexical-SealRequireHints-%{version}

%build
perl Build.PL --installdirs=vendor --optimize="$RPM_OPT_FLAGS"
./Build

%install
./Build install --destdir=$RPM_BUILD_ROOT --create_packlist=0
find $RPM_BUILD_ROOT -type f -name '*.bs' -empty -delete
# %{_fixperms} $RPM_BUILD_ROOT

%check
./Build test

%files
%doc Changes README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/Lexical*

%changelog
