%define _unpackaged_files_terminate_build 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Text/Patch.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
Name: perl-UUID
Version: 0.37
Release: alt2
Summary: DCE compatible Universally Unique Identifier library for Perl

Group: Development/Perl
License: Artistic-2.0 AND (GPL-1.0-or-later OR Artistic-1.0-Perl)
Url: https://metacpan.org/release/UUID

Source0: http://www.cpan.org/authors/id/J/JR/JRM/UUID-%{version}.tar.gz

BuildRequires: perl(Devel/CheckLib.pm) perl(ExtUtils/MakeMaker.pm)
# Optional tests:
BuildRequires:  perl(Digest/SHA1.pm)

%description
The UUID library is used to generate unique identifiers for objects that
may be accessible beyond the local system. For instance, they could be
used to generate unique HTTP cookies across multiple web servers without
communication between the servers, and without fear of a name clash.
The generated UUIDs can be reasonably expected to be unique within a
system, and unique across all systems, and are compatible with those
created by the Open Software Foundation (OSF) Distributed Computing
Environment (DCE) utility uuidgen.

%prep
%setup -q -n UUID-%{version}
# Remove always skipped tests
for T in t/0gen.t t/9benchmark/*.t; do
    rm -- "$T"
    perl -i -ne 'print $_ unless m{^\Q'"$T"'\E}' MANIFEST
done

%build
%perl_vendor_build

%install
%perl_vendor_install

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc Changes README
%perl_vendor_archlib/UUID.pm
%perl_vendor_autolib/UUID

%changelog
