Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Term/ReadLine.pm) perl(Test/Pod.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Supported rpmbuild options:
#
# --with live-test/--without live-test
#   include/exclude LIVE_TEST testsuite
#   Default: --without (Requires networking, doesn't work in mock)
%bcond_with     live_test

Name:           perl-Web-Scraper
Version:        0.38
Release:        alt3_20
Summary:        Web Scraping Toolkit using HTML and CSS Selectors or XPath expressions
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Web-Scraper
Source0:        https://cpan.metacpan.org/authors/id/M/MI/MIYAGAWA/Web-Scraper-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  rpm-build-perl
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Module/Build/Tiny.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(HTML/Entities.pm)
BuildRequires:  perl(HTML/Selector/XPath.pm)
BuildRequires:  perl(HTML/Tagset.pm)
BuildRequires:  perl(HTML/TreeBuilder.pm)
BuildRequires:  perl(HTML/TreeBuilder/XPath.pm)
BuildRequires:  perl(HTML/TreeBuilder/LibXML.pm)
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(LWP.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/Base.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Requires.pm)
BuildRequires:  perl(UNIVERSAL/require.pm)
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XML/XPathEngine.pm)
BuildRequires:  perl(YAML.pm)
BuildRequires:  perl(strict.pm)

# Required by the testsuite
BuildRequires:  /bin/ps


# rpm's deptracker misses these:
Requires:  perl(LWP/UserAgent.pm)


Source44: import.info

%description
Web::Scraper is a web scraper toolkit, inspired by Ruby's equivalent
Scrapi. It provides a DSL-ish interface for traversing HTML documents and
returning a neatly arranged Perl data structure.

%prep
%setup -q -n Web-Scraper-%{version}

# Package does not depend on ExtUtils::MakeMaker
sed -i '/ExtUtils::MakeMaker/d' META.*

%build
/usr/bin/perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=$RPM_BUILD_ROOT --create_packlist=0

# Web-Scraper >= 0.38 misses to install bin/scaper
# Install it manually
install -m 755 -d ${RPM_BUILD_ROOT}%{_bindir}
install -m 755 bin/scraper ${RPM_BUILD_ROOT}%{_bindir}

find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} $RPM_BUILD_ROOT/*

%check
LEAK_TEST=1 %{?with_live_test:LIVE_TEST=1} ./Build test

%files
%doc Changes README
%{_bindir}/scraper
%{perl_vendor_privlib}/*

%changelog
