%define php_sapi cgi-fcgi

Name: php8.3-cgi
Version: %php_version
Release: %php_release
Summary: The PHP HTML-embedded scripting language as a CGI (FastCGI) binary.
Group: System/Servers
Url: http://www.php.net/
License: PHP-3.01
Source1: php-cgi-alt.ini
Source2: php-cgi-browscap.ini

%if "%_php_suffix" != "8.4"
Patch0: php8.2-sapi-cgi-alt-build-fastcgi.patch
%else
Patch0: php8.4-sapi-cgi-alt-build-fastcgi.patch
%endif

Requires: php8.3 = %php_version
Provides: php-engine = %php_version-%php_release
BuildRequires(pre): rpm-build-php8.3-version rpm-macros-apache

BuildRequires: libpcre-devel zlib-devel libfcgi-devel 
BuildRequires: php-devel = %php_version

%def_disable debug

%description
PHP is an HTML-embedded scripting language.  PHP attempts to make it
easy for developers to write dynamically generated web pages.  PHP
also offers built-in database integration for several commercial
and non-commercial database management systems, so writing a
database-enabled web page with PHP is fairly simple.  The most
common use of PHP coding is probably as a replacement for CGI
scripts.
Using PHP as a CGI binary is an option for setups that for some reason
do not wish to integrate PHP as a module into server software (like Apache),
or will use PHP with different kinds of CGI wrappers to create safe
chroot and setuid environments for scripts.
This setup usually involves installing executable PHP binary to the
web server cgi-bin directory. CERT advisory CA-96.11 recommends
against placing any interpreters into cgi-bin.

%prep
%setup -T -c
%php_sapi_prepare cgi

%patch0 -p1


%build

CGI_BUILD_VARS=" \
    install_targets=install-sapi \
    PHP_SAPI=default \
    PHP_MODULES=sapi/cgi/php-cgi \
    EXTRA_LIBS=-lphp-%_php_version \
    BUILD_DIR=./ \
"
cp -f config9.m4 config.m4
mkdir -p sapi modules
[ -s sapi/cgi ] || ln -s ../ sapi/cgi

phpize $CGI_BUILD_VARS
%configure \
	%{subst_enable debug} \
	--enable-cgi \
	--with-php-config=%_bindir/php-config \
	$CGI_BUILD_VARS 

%php_make 
cat php-cgi.1.in > php-cgi.1

%install
%__mkdir_p \
	%buildroot/%_bindir \
	%buildroot/%php_sysconfdir/%php_sapi/php.d
	
%php_make install-cgi program_suffix=-%_php_suffix INSTALL_ROOT=%buildroot bindir=%_bindir mandir=%_mandir
# php-cgi.1 points to man1/php.1
rm -rf %buildroot%_mandir

%__install -m 644 %SOURCE1 %buildroot/%php_sysconfdir/%php_sapi/php.ini
%__install -m 644 %SOURCE2 %buildroot/%php_sysconfdir/%php_sapi/browscap.ini

for f in \
        %buildroot/%php_sysconfdir/%php_sapi/php.ini
do
  subst 's,@SAPI@,%php_sapi,g' "$f"
  subst 's,@PHP_VERSION@,%_php_version,g' "$f"
  subst 's,@PHP_MAJOR@,%_php_major,g' "$f"
  subst 's,@PHP_LIBDIR@,%_libdir/php,g' "$f"
  subst 's,@CGIBINDIR@,%webserver_cgibindir,g' "$f"
  subst 's,@PHP_BROWSCAP@,%php_sysconfdir/%php_sapi/browscap.ini,g' "$f"
done

%post
%php_sapi_postin

%preun
%php_sapi_preun

%files
%_bindir/php-cgi-%_php_suffix
%config(noreplace) %php_sysconfdir/%php_sapi/php.ini
%php_sysconfdir/%php_sapi
%doc CREDITS

%changelog
