%define		php_extension	xsl

Name:	 	php%_php_suffix-%php_extension
Version:	%php_version
Release:	%php_release.1

Summary:	Sablotron XSLT support for PHP
Group:		System/Servers
License:	PHP-3.01

Prereq:		php%_php_suffix-dom

Source1:	php-%php_extension.ini
Source2:	php-%php_extension-params.sh

BuildRequires(pre): rpm-build-php8.4-version
BuildRequires:	php-devel = %php_version

# Automatically added by buildreq on Fri Jul 01 2005
BuildRequires: libxml2-devel libxslt-devel zlib-devel

%description
The %name includes a dynamic shared object (DSO) that adds
XSLT support to PHP. Sablotron is a fast, compact and portable XSLT processor.
If you need XSLT support for PHP applications, you will need
to install this package in addition to the php package.

%prep
%setup -T -c
cp -pr %php_extsrcdir/%php_extension/* .

%build
phpize

BUILD_HAVE=`echo %php_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir -I/%php_includedir/%php_version/ext/xml
export LDFLAGS=-lphp-%_php_version
%configure \
	PHP_DOM=yes \
	PHP_LIBXML_SHARED=yes \
	--with-%php_extension=%_usr
%php_make

%install
%php_make_install
install -D -m 644 %SOURCE1 %buildroot/%php_extconf/%php_extension/config
install -D -m 644 %SOURCE2 %buildroot/%php_extconf/%php_extension/params

%files
%php_extconf/%php_extension
%php_extdir/*
%doc CREDITS

%post
%php_extension_postin

%preun
%php_extension_preun

%changelog
