# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: picom
Version: 11.2
Release: alt1
Summary: A lightweight compositor for X11
License: MPL-2.0 or MIT
Group: System/X11
Url: https://github.com/yshui/picom
Source: %name-%version.tar
Source44: %name.watch
Obsoletes: compton < %EVR
Provides: compton = %version

BuildRequires: asciidoc-a2x
BuildRequires: rpm-build-python3
BuildRequires: meson
BuildRequires: libX11-devel
BuildRequires: libXext-devel
BuildRequires: libconfig-devel
BuildRequires: libGL-devel
BuildRequires: libEGL-devel
BuildRequires: libepoxy-devel
BuildRequires: libdbus-devel
BuildRequires: libev-devel
BuildRequires: libuthash-devel
BuildRequires: pkgconfig(xcb-renderutil)
BuildRequires: pkgconfig(xcb-image)
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(libxdg-basedir)
BuildRequires: pkgconfig(xcb-util)
BuildRequires: pkgconfig(libpcre2-8)

%description
This is forked from the original Compton because it seems to have become
unmaintained.

The current battle plan of this fork is to refactor it to make the code
possible to maintain, so potential contributors won't be scared away when they
take a look at the code.

We also try to fix bugs.

You can leave your feedbacks or thoughts in the discussion tab.

%prep
%setup
%ifarch %e2k
sed -i "s/const auto/auto/" src/{render,win,picom}.c src/backend/xrender/xrender.c
sed -i "s/__attribute__((optimize(".*")))//" src/utils.h
sed -i "/#warning Use of -ffast-math/s/#warning/#error/" src/utils.h
%endif

%build
%meson -D with_docs=True
%meson_build

%install
%meson_install

%find_lang %name

%files -f %name.lang
%doc CONTRIBUTORS LICENSE.* README* dbus-examples man/%{name}* picom.sample.conf
%_bindir/*
%_sysconfdir/xdg/autostart/picom.desktop
%exclude %_datadir/applications/*.desktop
%_iconsdir/hicolor/*/*/*
%_man1dir/*

%changelog
