%define _unpackaged_files_terminate_build 1

Name: pingus
Version: 0.7.6
Release: alt4

Summary: A free Lemmings clone
Summary(ru_RU.UTF8): Свободный клон Lemmings
License: GPL
Group: Games/Arcade
Url: http://pingus.seul.org

Packager: Ilya Mashkin <oddity@altlinux.ru>

Source: %name-%version.tar
Source1: %name.16.xpm
Source2: %name.32.xpm
Source3: %name.48.xpm
Source4: CMakeLists.txt

Patch8:  pingus-0.7.6-alt-VERSION.patch
Patch9:  pingus-0.7.6-upstream-std-header.patch
Patch10: pingus-0.7.6-upstream-boost-compat.patch

# Automatically added by buildreq on Fri Sep 28 2007
BuildRequires: esound flex gcc-c++ ghostscript-utils libSDL-devel
BuildRequires: libSDL_mixer-devel libSDL_image-devel boost-devel libpng-devel
BuildRequires: libphysfs-devel boost-signals-devel
BuildRequires: cmake

%description
Pingus is a free Lemmings clone covered under the GPL. Pingus uses SDL,
which should make it portable over a lot of operating systems in the future. At
the moment the main target is Linux. It is possible to play Pingus in a X
window or in fullscreen.

%description -l ru_RU.UTF8
Pingus - свободный клон Lemmings, выпускаемый под GPL. Pingus использует
SDL, что должно сделать его портируемым на множество других операционных
систем в будущем. На данный момент главная цель - Linux. В Pingus возможно
играть в X в окне или в полноэкранном режиме.

%prep
%setup
%patch8 -p2
%patch9 -p1
%patch10 -p1

cp %SOURCE4 CMakeLists.txt

%build
%cmake \
	-DWARNINGS:BOOL=ON \
	-DBUILD_EXTRA:BOOL=OFF \
	-DBUILD_TESTS:BOOL=OFF \
	%nil

%cmake_build

%install
%cmakeinstall_std

install -pD -m644 %SOURCE1 %buildroot%_miconsdir/%name.xpm
install -pD -m644 %SOURCE2 %buildroot%_niconsdir/%name.xpm
install -pD -m644 %SOURCE3 %buildroot%_liconsdir/%name.xpm

install -m755 -d %buildroot%_desktopdir/
cat > %buildroot%_desktopdir/%{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=Pingus
Comment=Guide the penguins safely home before they drop of the cliff
Exec=pingus
Icon=pingus
Terminal=false
StartupNotify=false
Categories=Game;ArcadeGame;
EOF

# revert to previous run script since just starting application without any parameters doesn't work yet
mv %buildroot%_bindir/%name %buildroot%_bindir/%{name}.bin

cat > %buildroot%_bindir/%name << EOF
#!/bin/sh
exec "%_bindir/%{name}.bin" --datadir "%_datadir/%name"
EOF

chmod +x %buildroot%_bindir/%name

# remove unnecessary files since they just create unnecessary dependencies
rm -f %buildroot%_datadir/%name/images/fonts/buildset.py
rm -f %buildroot%_datadir/%name/images/fonts/substractchars.py
rm -f %buildroot%_datadir/%name/po/extract-levels.guile
rm -f %buildroot%_datadir/%name/po/extract-po.sh
rm -f %buildroot%_datadir/%name/po/pingus.pot
rm -f %buildroot%_datadir/%name/po/update-po.sh

%find_lang %name

%files -f %name.lang
%_bindir/*
%_datadir/%name
%_man6dir/*
%_desktopdir/%{name}.desktop
%_miconsdir/%name.xpm
%_niconsdir/%name.xpm
%_liconsdir/%name.xpm
%_iconsdir/hicolor/scalable/apps/%{name}.svg
%doc AUTHORS NEWS README TODO

%changelog
