%global _unpackaged_files_terminate_build 1
%global import_path github.com/containers/podman
%define _libexecdir %_usr/libexec
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%define _systemdgeneratordir %_prefix/lib/systemd/system-generators

Name:     podman
Version:  5.5.2
Release:  alt1

Summary:  Manage pods, containers, and container images
License:  Apache-2.0 AND BSD-2-Clause AND BSD-3-Clause AND ISC AND MIT AND MPL-2.0
Group:    System/Configuration/Other
Vcs:      https://github.com/containers/podman.git
Url:      https://podman.io/

Source:   %name-%version.tar

ExclusiveArch: %go_arches
BuildRequires(pre): rpm-macros-golang rpm-macros-systemd
BuildRequires: rpm-build-golang golang >= 1.23.3
BuildRequires: go-md2man man-db
BuildRequires: libseccomp-devel glib2-devel libgpgme-devel libgpg-error-devel libbtrfs-devel
BuildRequires: libgio-devel libostree-devel libselinux-devel libdevmapper-devel
BuildRequires: libassuan-devel libsystemd-devel libsubid-devel
BuildRequires: /proc

Conflicts: filesystem < 3

Requires: catatonit
Requires: conmon >= 2.1.7
Requires: containers-common-extra
%ifnarch %e2k %arm %ix86
Requires: netavark >= 1.6.0 aardvark-dns
%endif
Requires: oci-runtime
Requires: xz
Requires: shadow-submap
Obsoletes: %name-quadlet <= 4.4.0
Provides: %name-quadlet = %EVR

%description
%summary.

%package   docker
Summary:   Emulate Docker CLI using podman
Group:     System/Configuration/Other
BuildArch: noarch
Requires:  %name = %EVR
Conflicts: docker-ce
Conflicts: docker-ee
Conflicts: docker-engine
Conflicts: docker-cli
Conflicts: moby-engine

%description docker
%summary.

%package  remote
Group:    System/Configuration/Other
Summary:  (Experimental) Remote client for managing %name containers
Requires: %name = %EVR

%description remote
Remote client for managing %name containers.

%name-remote uses the libpod REST API to connect to a %name client to
manage pods, containers and container images. %name-remote supports ssh
connections as well.

%package  machine
Summary:  Metapackage for setting up %name machine
Group:    System/Configuration/Other
Requires: %name = %EVR
Requires: gvisor-tap-vsock
Requires: qemu-kvm
Requires: virtiofsd

%description machine
This subpackage installs the dependencies for %name machine.

%prep
%setup
%autopatch -p1

%build
export CGO_CFLAGS=$CFLAGS

%ifnarch %ix86 %mips32 %arm
export CGO_CFLAGS+=" -D_FILE_OFFSET_BITS=64"
%endif

%ifarch x86_64
# Builds only on x86_64 with this flag
export CGO_CFLAGS+=" -m64 -mtune=generic"
export CGO_CFLAGS+=" -fcf-protection=full"
%endif

export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export GOFLAGS="-mod=vendor"
export RELEASE_VERSION=v%version
export RELEASE_NUMBER=%version
export GIT_COMMIT=%release

%golang_prepare

pushd .gopath/src/%import_path
#%%make test/version/version
go build -o test/version/version ./test/version/
%make_build PREFIX=%_prefix ETCDIR=%_sysconfdir TMPFILESDIR=%_tmpfilesdir SYSTEMDDIR=%_unitdir MODULESLOADDIR=%_modulesloaddir
%make docs docker-docs
popd

%install
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path:$PWD"
export RELEASE_VERSION=v%version
export RELEASE_NUMBER=%version
export GIT_COMMIT=%release

pushd .gopath/src/%import_path
%make DESTDIR=%buildroot PREFIX=%_prefix ETCDIR=%_sysconfdir TMPFILESDIR=%_tmpfilesdir MODULESLOADDIR=%_modulesloaddir \
    SYSTEMDDIR=%_unitdir SYSTEMDGENERATORSDIR=%_systemdgeneratordir USERSYSTEMDGENERATORSDIR=%_systemdusergeneratordir \
    install.bin \
    install.remote \
    install.modules-load \
    install.man \
    install.completions \
    install.systemd \
    install.docker \
    install.docker-docs
popd

echo br_netfilter >> %buildroot%_modulesloaddir/podman-iptables.conf
rm -f %buildroot%_man5dir/dockerignore*
rm -f %buildroot%_man5dir/dockerfile*

%ifnarch %e2k %arm %ix86 %mips32
# symlink virtiofsd in %%name libexecdir for machine subpackage
ln -s ../virtiofsd %buildroot%_libexecdir/%name
%endif

%files
%_bindir/%name
%_bindir/%{name}sh
%_datadir/bash-completion/completions/%name
%_datadir/zsh/site-functions/_%name
%_datadir/fish/vendor_completions.d/%name.fish
%_unitdir/*
%_userunitdir/*
%_systemdgeneratordir/*
%_systemdusergeneratordir/*
%_modulesloaddir/*
%_man1dir/*
%_man5dir/*
%_man7dir/*
%exclude %_man1dir/%name-remote*
%exclude %_man1dir/docker*
%doc *.md
%_tmpfilesdir/%name.conf
%dir %_libexecdir/%name
%_libexecdir/%name/quadlet
%_libexecdir/%name/rootlessport

%files remote
%_bindir/%name-remote
%_man1dir/%name-remote*
%_man1dir/docker-remote*
%_datadir/bash-completion/completions/%name-remote
%_datadir/fish/vendor_completions.d/%name-remote.fish
%_datadir/zsh/site-functions/_%name-remote

%files docker
%config(noreplace) %_sysconfdir/profile.d/%name-docker.*
%_bindir/docker
%_man1dir/docker*
%exclude %_man1dir/docker-remote*
%_tmpfilesdir/%name-docker.conf
%_user_tmpfilesdir/%name-docker.conf

%ifnarch %e2k %arm %ix86 %mips32
%files machine
%_libexecdir/%name/virtiofsd
%endif

%changelog
