%define polkit_qt5_agent_major 1
%define polkit_qt5_gui_major 1
%define polkit_qt5_core_major 1

Name: polkit-qt5
Version: 0.175.0
Release: alt1

Summary: Qt 5 bindings for PolicyKit
License: GPL-2.0-or-later
Group: System/Libraries

Url: https://invent.kde.org/libraries/polkit-qt-1
# Source-url: https://invent.kde.org/libraries/polkit-qt-1/-/archive/v%version/polkit-qt-1-v%version.tar.gz
Source: polkit-qt-1-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++
BuildRequires: extra-cmake-modules cmake
BuildRequires: libpolkit1-devel
BuildPreReq: qt5-base-devel
BuildPreReq: kde-common-devel

%description
Polkit-qt5 is a library that lets developers use the PolicyKit API
through a nice Qt-styled API.

%package -n libpolkit-qt5-agent
Summary: %summary
Group: System/Libraries

%description -n libpolkit-qt5-agent
%summary.

%package -n libpolkit-qt5-core
Summary: %summary
Group: System/Libraries

%description -n libpolkit-qt5-core
%summary.

%package -n libpolkit-qt5-gui
Summary: %summary
Group: System/Libraries

%description -n libpolkit-qt5-gui
%summary.

%package -n libpolkitqt5-qt5-devel
Summary: Development files for PolicyKit Qt 5 bindings
Group: Development/KDE and QT
Requires: libpolkit-qt5-agent
Requires: libpolkit-qt5-core
Requires: libpolkit-qt5-gui
Provides: polkitqt5-devel

%description -n libpolkitqt5-qt5-devel
%summary.

%prep
%setup -n polkit-qt-1-%version

%build
%cmake \
	-DBUILD_EXAMPLES:BOOL=OFF \
	-DLIB_DESTINATION=%_libdir \
	#
%cmake_build

# Remove installdox file - it is not necessary here
rm -fv html/installdox

%install
%cmake_install

%files -n libpolkit-qt5-agent
%_libdir/libpolkit-qt5-agent-1.so.%{polkit_qt5_agent_major}*

%files -n libpolkit-qt5-core
%_libdir/libpolkit-qt5-core-1.so.%{polkit_qt5_core_major}*

%files -n libpolkit-qt5-gui
%_libdir/libpolkit-qt5-gui-1.so.%{polkit_qt5_gui_major}*

%files -n libpolkitqt5-qt5-devel
%doc AUTHORS README
%_includedir/polkit-qt5-1/
%_libdir/libpolkit-qt5-core-1.so
%_libdir/libpolkit-qt5-gui-1.so
%_libdir/libpolkit-qt5-agent-1.so
%_libdir/pkgconfig/polkit-qt5-1.pc
%_libdir/pkgconfig/polkit-qt5-core-1.pc
%_libdir/pkgconfig/polkit-qt5-gui-1.pc
%_libdir/pkgconfig/polkit-qt5-agent-1.pc
%_libdir/cmake/PolkitQt5-1/

%changelog
