%define pg_ver 13

Name: postgresql%pg_ver-timescaledb
Version: 2.15.3
Release: alt1
Summary: Open-source time-series database powered by PostgreSQL
Group: Databases
License: Apache-2.0 and Timescale License
Url: http://www.timescale.com
Source0: %name-%version.tar

BuildRequires: cmake
BuildRequires: libssl-devel libkrb5-devel
BuildRequires: postgresql%pg_ver-server-devel

Requires: postgresql%pg_ver-server

%description
TimescaleDB is an open-source database designed to make SQL scalable for
time-series data.  It is engineered up from PostgreSQL, providing automatic
partitioning across time and space (partitioning key), as well as full SQL
support.

%prep
%setup

%build
%cmake \
    -DUSE_OPENSSL=ON \
    -DSEND_TELEMETRY_DEFAULT=OFF \
    -DREGRESS_CHECKS=OFF \
    -DAPACHE_ONLY=OFF \
    -DPG_CONFIG=%_bindir/pg_server_config

%cmake_build

%install
%cmakeinstall_std

%post
echo "Execute the following psql command inside any database that you want to update:"
echo "ALTER EXTENSION timescaledb UPDATE;                                            "

%files
%doc README.md LICENSE LICENSE-APACHE
%_libdir/pgsql/*
%_datadir/pgsql/extension/*

%changelog
