%define pg_ver 15
%def_with jit

Name: postgresql%pg_ver-pg_repack
Version: 1.5.3
Release: alt1

Summary: pg_repack is a PostgreSQL extension which lets you remove bloat from tables and indexes
License: BSD
Group: Databases
Url: https://github.com/reorg/pg_repack

Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: libecpg6-%pg_ver-devel-static postgresql%pg_ver-server-devel
BuildRequires: libzstd-devel liblz4-devel libssl-devel zlib-devel
BuildRequires: libreadline-devel setproctitle-devel libnuma-devel

Requires: postgresql%pg_ver-server

%description
pg_repack_ is a PostgreSQL extension which lets you remove bloat from
tables and indexes, and optionally restore the physical order of clustered
indexes. Unlike CLUSTER_ and `VACUUM FULL`_ it works online, without
holding an exclusive lock on the processed tables during processing.
pg_repack is efficient to boot, with performance comparable to using
CLUSTER directly.

%prep
%setup
%patch0 -p1

%build
%make PG_CONFIG=/usr/bin/pg_server_config

%install
%makeinstall_std

%files
%_bindir/*
%_libdir/pgsql/*.so
%if_with jit
%_libdir/pgsql/bitcode/*
%endif
%_datadir/pgsql/extension/*

%changelog
