Name: pound
Version: 4.9
Release: alt1

Summary: Reverse proxy, load balancer and HTTPS front-end for Web servers
License: GPLv3+
Group: System/Servers

Url: https://github.com/graygnuorg/pound
Source: pound-%version.tgz
Source1: pound.init
Source2: pound.cfg
Source3: pound.sysconfig

BuildRequires: libgperftools-devel libpcre2-devel openssl-devel openssl

%description
Pound was developed to enable distributing the load among several Web-servers
and to allow for a convenient SSL wrapper for those Web servers that do not
offer it natively.

%prep
%setup

%build
%configure \
    --localstatedir=/ \
    --with-maxbuf=8192   # http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=293915

%make_build

%install
%makeinstall_std

install -d %buildroot{%_initrddir,/etc/sysconfig}
install -p -m0755 %_sourcedir/pound.init %buildroot%_initrddir/pound
install -p -m0644 %_sourcedir/pound.cfg %buildroot/etc/
install -p -m0644 %_sourcedir/pound.sysconfig %buildroot/etc/sysconfig/pound

%post
%post_service pound

/usr/sbin/groupadd -r -f _pound
/usr/sbin/useradd -r -g _pound -d /dev/null -s /dev/null -n _pound >/dev/null 2>&1 ||:

%preun
%preun_service pound

%files
%doc AUTHORS COPYING ChangeLog.apsis NEWS README THANKS
%config(noreplace) /etc/pound.cfg
%config(noreplace) /etc/sysconfig/pound
%config(noreplace) %_initrddir/*
%_sbindir/*
%_bindir/*
%dir %_datadir/pound/
%_datadir/pound/*
%_man5dir/*
%_man8dir/*

%changelog
