# TODO: fix nuget to operate offline
%def_with prebuild

%define dotnetver 8.0
%define _dotnet_corerelease %{dotnetver}*

Name: powershell
Version: 7.4.1
Release: alt1

Summary: PowerShell for every system!

License: MIT
Url: https://github.com/PowerShell/PowerShell
Group: Development/Other

# Source-url: https://github.com/PowerShell/PowerShell/archive/v%version.tar.gz
Source: %name-%version.tar

# Source1-url: https://github.com/PowerShell/PowerShell/releases/download/v%version/powershell-%version-linux-x64-fxdependent.tar.gz
Source1: %name-prebuild-%version.tar

Source2: %name.1
Source3: Microsoft.PowerShell.SDK.csproj.TypeCatalog.targets

ExclusiveArch: %_dotnet_archlist

BuildRequires(pre): rpm-macros-dotnet >= 6.0

AutoReq:yes,nonodejs,nonodejs_native,nomono,nomonolib,nopython,nomingw32,nomingw64,noshebang
AutoProv: no

Requires: dotnet-%dotnetver

BuildRequires: cmake gcc-c++
BuildRequires: dotnet-sdk-%dotnetver


# >= 1.2.100035
Requires: libomi >= 1.2.0
Requires: libpsrp >= 1.4.4
Requires: libpsl-native
#BuildRequires: libpsrp
#BuildRequires: libpsl-native

#if_without prebuild
# local nuget cache
#BuildRequires: nuget-packages >= 20170602
#endif

BuildRequires: /proc

%description
PowerShell is a cross-platform (Windows, Linux, and macOS) automation and configuration tool/framework
that works well with your existing tools and is optimized for dealing with structured data
(e.g. JSON, CSV, XML, etc.), REST APIs, and object models. It includes a command-line shell,
an associated scripting language and a framework for processing cmdlets.

%prep
%setup -a1

%build
%if_without prebuild
#export NUGET_PACKAGES=$(pwd)/nuget
#export NUGET_FALLBACK_PACKAGES=$(pwd)/nuget-fallback

# https://aur.archlinux.org/cgit/aur.git/tree/PKGBUILD?h=powershell
export DOTNET_SKIP_FIRST_TIME_EXPERIENCE=true
export DOTNET_CLI_TELEMETRY_OPTOUT=true
subst "s|git describe --abbrev=60 --long|echo %version-%release|" PowerShell.Common.props

## Restore
dotnet restore src/powershell-unix
dotnet restore src/ResGen
dotnet restore src/TypeCatalogGen

## Setup the build target to gather dependency information (see Start-TypeGen function in build.psm1)
cp %SOURCE3 src/Microsoft.PowerShell.SDK/obj/Microsoft.PowerShell.SDK.csproj.TypeCatalog.targets
dotnet msbuild src/Microsoft.PowerShell.SDK/Microsoft.PowerShell.SDK.csproj /t:_GetDependencies "/property:DesignTimeBuild=true;_DependencyFile=$(pwd)/src/TypeCatalogGen/powershell.inc" /nologo

## Generate 'powershell.version'
echo %version-%release >powershell.version

## create the telemetry flag file
touch "DELETE_ME_TO_DISABLE_CONSOLEHOST_TELEMETRY"

## Generate resource binding C# files
pushd src/ResGen
dotnet run
popd

## Generate 'CorePsTypeCatalog.cs'
pushd src/TypeCatalogGen
dotnet run ../System.Management.Automation/CoreCLR/CorePsTypeCatalog.cs powershell.inc
popd

## Build powershell core
dotnet publish --configuration Linux "src/powershell-unix/" --output bin --runtime "%_dotnet_rid"

# TODO: generate man from assets/powershell.1.ronn
%endif

%install
%if_with prebuild
mkdir -p %buildroot%_libdir/%name/
cp -a %name-prebuild/* %buildroot%_libdir/%name/
rm -rv %buildroot%_libdir/%name/runtimes/{linux-,win,osx,freebsd,illumos,ios,solaris,tvos}*
#rm -v %buildroot%_libdir/%name/{libcrypto.so.1.0.0,libssl.so.1.0.0}
mkdir -p %buildroot%_libdir/%name/runtimes/%_dotnet_rid/native/
# hack to use latest runtime
#__subst "s|2.0.0-preview1-002111-00|%_dotnet_corerelease|g" %buildroot%_libdir/%name/powershell.runtimeconfig.json
#cp -f %_libdir/libpsl-native.so %buildroot%_libdir/%name/
#rm -v %buildroot%_libdir/%name/DELETE_ME_TO_DISABLE_CONSOLEHOST_TELEMETRY

# replace binary pwsh
#mkdir -p %buildroot%_libdir/%name/
cat <<EOF >%buildroot%_libdir/%name/pwsh
#!/bin/sh
exec dotnet %_libdir/%name/pwsh.dll "\$@"
EOF

# replace binary Microsoft.PowerShell.GlobalTool.Shim
cat <<EOF >%buildroot%_libdir/%name/Microsoft.PowerShell.GlobalTool.Shim
#!/bin/sh
exec dotnet %_libdir/%name/Microsoft.PowerShell.GlobalTool.Shim.dll "\$@"
EOF

#chmod 0755 %buildroot%_libdir/%name/pwsh

# replace downloaded libs with system versions

ln -sf %_libdir/libmi.so %buildroot%_libdir/%name/runtimes/%_dotnet_rid/native/libmi.so
#ln -sf %_libdir/libpsrpclient.so %buildroot%_libdir/%name/runtimes/%_dotnet_rid/native/libpsrpclient.so
#ln -sf %_libdir/libpsl-native.so %buildroot%_libdir/%name/runtimes/%_dotnet_rid/native/libpsl-native.so
cp -a %_dotnet_coreapp/libSystem.IO.Ports.Native.so %buildroot%_libdir/%name/runtimes/%_dotnet_rid/native/libSystem.IO.Ports.Native.so

%else
#dotnet publish --configuration Linux src/powershell-unix/ --output %buildroot%_libdir/%name/ --runtime linux-x64
#dotnet publish --configuration Linux src/powershell-unix/ --output %buildroot%_libdir/%name/
# cp -a bin/* %buildroot%_libdir/%name/
%endif

mkdir -p %buildroot%_man1dir/
cp -v %SOURCE2 %buildroot%_man1dir/

mkdir -p %buildroot%_bindir/
ln -s %_libdir/%name/pwsh %buildroot%_bindir/pwsh
ln -s pwsh %buildroot%_bindir/%name

%files
%_bindir/%name
%_bindir/pwsh
%_libdir/%name/
%_man1dir/%name.*
%doc docs/*

%changelog
