Name: profile-sync-daemon
Version: 6.45
Release: alt1
Summary: Offload browser profiles to RAM for speed a wear reduction
Summary(ru_RU.UTF-8): Выгружает профиль браузера в ОЗУ для ускорения его работы
License: MIT
Group: Networking/WWW
Url: https://github.com/graysky2/profile-sync-daemon

Source: %name-%version.tar

BuildArch: noarch
%add_findreq_skiplist %_bindir/%name

%description
Profile-sync-daemon (psd) is a tiny pseudo-daemon designed to manage your
browser's profile in tmpfs and to periodically sync it back to your physical
disc (HDD/SSD). This is accomplished via a symlinking step and an innovative
use of rsync to maintain back-up and synchronization between the two. One of
the major design goals of psd is a completely transparent user experience.

To automatically start psd, use the command:
systemctl --user enable psd psd-resync.timer && systemctl --user start psd psd-resync.timer

%description -l ru_RU.UTF-8
Profile-sync-daemon (psd) представляет собой псевдо-демон, управляющий вашим
профилем браузера в tmpfs и периодически синхронизирующий его для восстановления
на вашем физическом диске (HDD/SSD). Это достигается с помощью создания
символических ссылок и инновационного использованию Rsync для резервного
копирования и синхронизации. Поддерживается большинство современных браузеров.

Для автоматического запуска psd, используйте команду:
systemctl --user enable psd psd-resync.timer && systemctl --user start psd psd-resync.timer

%prep
%setup

sed -i '/Wants=psd-resync.service/d' init/psd.service
sed -i '/\[Timer\]/a OnStartupSec=10s' init/psd-resync.timer

cat>>init/psd-resync.timer<<END

[Install]
WantedBy=timers.target
END

%build
%make_build

%install
%makeinstall_std

%post
echo 'To automatically start psd, use the command:'
echo 'systemctl --user enable psd psd-resync.timer && systemctl --user start psd psd-resync.timer'

%files
%doc README*
%_datadir/psd
%_bindir/*
%_man1dir/*.1*
%_libexecdir/systemd/user/psd*.*
%_datadir/zsh/site-functions/_psd

%changelog
