# Filter inner lua modules from requires
%filter_from_requires /^lua%current_lua_version(core.*/d
%filter_from_requires /^lua%current_lua_version(cqueues.*/d
%filter_from_requires /^lua%current_lua_version(net.*/d
%filter_from_requires /^lua%current_lua_version(util.*/d

Name: prosody
Version: 0.12.4
Release: alt1

Summary: Modern XMPP communication server

Group: System/Servers
License: MIT
Url: https://prosody.im/

BuildRequires(pre): liblua5.4-devel
BuildRequires: openssl lua5.4 libidn-devel libssl-devel libicu-devel

Requires: openssl

Source0: %name-%version.tar
Source1: prosody.cfg.lua
Source2: prosody.service
Source3: prosody.init
Source4: prosody.tmpfiles
Source10: autobuild.watch
Source11: upstream-signing-key.asc

Patch1: prosody-0.12.0-alt-user.patch
Patch2: prosody-0.12.1-alt-lua5.4.patch

%description
%summary

%prep
%setup
%autopatch -p1

%build
./configure --prefix=/usr
%make_build

sed -i "s,@LUA_VERSION@,%current_lua_version,g" %SOURCE3

%install
%makeinstall_std
mkdir -p %buildroot/%systemd_unitdir
mkdir -p %buildroot/%_localstatedir/prosody
# ALT 38692
mkdir -p %buildroot/%_sysconfdir/prosody/conf.d

mv %buildroot/%_sysconfdir/prosody/prosody.cfg.lua %buildroot/%_sysconfdir/prosody/prosody.cfg.example.lua
cp %SOURCE1 %buildroot/%_sysconfdir/prosody
cp %SOURCE2 %buildroot/%systemd_unitdir
install -Dpm755 %SOURCE3 %buildroot/%_initdir/prosody
install -Dpm644 %SOURCE4 %buildroot/%_tmpfilesdir/prosody.conf

%pre
/usr/sbin/groupadd -r -f _prosody
/usr/sbin/useradd -r -g _prosody -d %_localstatedir/%name -s /sbin/nologin -n -c "%summary" _prosody >/dev/null 2>&1 ||:

%preun
%preun_service prosody

%post
%post_service prosody

%files
%doc AUTHORS CHANGES CONTRIBUTING COPYING HACKERS README
%_bindir/*
%_libexecdir/prosody
%config(noreplace) %_sysconfdir/prosody
%systemd_unitdir/prosody.service
%_initdir/prosody
%attr(0755,_prosody,_prosody) %dir %_localstatedir/prosody
%_tmpfilesdir/prosody.conf
%_man1dir/*

%changelog
