%define oname protobuf
%define soversion 25

# set 'enable' to build legacy package
%def_disable legacy

%if_disabled legacy
%define _unpackaged_files_terminate_build 1

# Tests on e2k takes 3-4 days (!)
%ifarch %e2k
%def_disable check
%endif

%ifarch riscv64 %mips %e2k
%def_without java_tests
%else
%def_with java_tests
%endif

# normal package may include python3 or java support
%def_with python3
%def_with java
%def_with ruby
%else
# for legacy package python3 and java should always be disabled since it's not packed anyway
%def_without python3
%def_without java
%def_without ruby
%endif

%if_disabled legacy
Name: %oname
%else
Name: %oname%soversion
%endif
Version: 3.25.5
Release: alt6
Summary: Protocol Buffers - Google's data interchange format
License: BSD-3-Clause
%if_disabled legacy
Group: System/Libraries
%else
Group: System/Legacy libraries
%endif
Url: https://github.com/protocolbuffers/protobuf
Vcs: https://github.com/protocolbuffers/protobuf.git

# https://github.com/protocolbuffers/protobuf.git
Source: %oname-%version.tar
Patch: %oname-%version.patch

Obsoletes: libprotobuf <= 2.0.0-alt1

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake rpm-build-cmake ctest

BuildRequires: gcc-c++ zlib-devel libgtest-devel libabseil-cpp-devel

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel libnumpy-py3-devel
BuildRequires: python3-module-setuptools python-tools-2to3
BuildRequires: python3-module-dateutil
%endif
%if_with ruby
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(rake-compiler-dock) >= 1.1.0 gem(rake-compiler-dock) < 2
BuildRequires: gem(rake-compiler) >= 1.1.0 gem(rake-compiler) < 2
BuildRequires: gem(test-unit) >= 3.0 gem(test-unit) < 4

%ruby_use_gem_dependency rake-compiler >= 1.1.0,rake-compiler < 2
%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%endif

%description
Protocol Buffers are a way of encoding structured data in
an efficient yet extensible format. Google uses Protocol Buffers for
almost all of its internal RPC protocols and file formats.

%package compiler
Summary: Protocol Buffers Compiler
Group: Development/Other
Requires: lib%oname%soversion = %EVR

%description compiler
Compiler for protocol buffer definition files

%package -n lib%oname%soversion
Summary: Protocol Buffer c++ library
%if_disabled legacy
Group: System/Libraries
%else
Group: System/Legacy libraries
%endif

Provides: libprotobuf = %EVR

%description -n lib%oname%soversion
Protocol Buffers are a way of encoding structured data in
an efficient yet extensible format. Google uses Protocol Buffers for
almost all of its internal RPC protocols and file formats.

%package -n lib%oname%soversion-lite
Summary: Protocol Buffers LITE_RUNTIME libraries
%if_disabled legacy
Group: System/Libraries
%else
Group: System/Legacy libraries
%endif
Provides: libprotobuf-lite = %EVR

%description -n lib%oname%soversion-lite
Protocol Buffers built with optimize_for = LITE_RUNTIME.

The "optimize_for = LITE_RUNTIME" option causes the compiler to generate code
which only depends libprotobuf-lite, which is much smaller than libprotobuf but
lacks descriptors, reflection, and some other features.

%package -n lib%oname-devel
Summary: Development files for %oname
Group: Development/C
Requires: lib%oname%soversion = %EVR
# Protoc.%soversion and libprotobuf-lite.so.%soversion are required
# in protobuf-targets-noconfig.cmake.
Requires: lib%oname-lite-devel = %EVR
Requires: %name-compiler = %EVR

%description -n lib%oname-devel
This package contains development files required for packaging
%oname.

%package -n lib%oname-lite-devel
Summary: Protocol Buffers LITE_RUNTIME development libraries
Group: Development/C
Requires: lib%oname%soversion-lite = %EVR
Requires: lib%oname-devel = %EVR

%description -n lib%oname-lite-devel
This package contains development libraries built with
optimize_for = LITE_RUNTIME.

The "optimize_for = LITE_RUNTIME" option causes the compiler to generate code
which only depends libprotobuf-lite, which is much smaller than libprotobuf but
lacks descriptors, reflection, and some other features.

%package -n python3-module-%oname
Summary: Python module files for %oname
Group: Development/Python3
Requires: lib%oname%soversion = %EVR
Conflicts: %name-compiler > %version
Conflicts: %name-compiler < %version

%description -n python3-module-%oname
Python bindings for protocol buffers

%if_with java
%package java
Summary: Java Protocol Buffers runtime library
Group: Development/Java
BuildArch:      noarch
BuildRequires:  /proc
BuildRequires:  jpackage-default
BuildRequires:  maven-local
BuildRequires:  mvn(com.google.code.gson:gson)
BuildRequires:  mvn(com.google.guava:guava)
BuildRequires:  mvn(com.google.guava:guava-testlib)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-antrun-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-source-plugin)
BuildRequires:  mvn(org.codehaus.mojo:build-helper-maven-plugin)
%if_with java_tests
BuildRequires:  mvn(org.mockito:mockito-core)
BuildRequires:  mvn(com.google.truth:truth)
BuildRequires:  mvn(junit:junit)
%endif
BuildRequires(pre):  rpm-build-java
BuildRequires:  libgmock-devel libgtest-devel
Conflicts: %name-compiler > %version
Conflicts: %name-compiler < %version
Obsoletes: %name-javanano < 3.6.0
# remove when xmvn will be patched to not insert this dep automatically
%filter_from_requires /^java-headless/d

%description java
This package contains Java Protocol Buffers runtime library.

%package javalite
Summary: Java Protocol Buffers lite runtime library
Group: Development/Java
BuildArch: noarch

%description javalite
This package contains Java Protocol Buffers lite runtime library.

%package javadoc
Summary: Javadocs for %oname-java
Group: Development/Documentation
BuildArch: noarch
Requires: %name-java = %EVR

%description javadoc
This package contains the API documentation for %oname-java.

%package java-util
Summary: Utilities for Protocol Buffers
Group: Development/Java
BuildArch: noarch

%description java-util
Utilities to work with protos. It contains JSON support
as well as utilities to work with proto3 well-known types.

%package parent
Summary: Protocol Buffer Parent POM
Group: Development/Java
BuildArch: noarch

%description parent
Protocol Buffer Parent POM.

%package bom
Summary: Protocol Buffer BOM POM
Group: Development/Java
BuildArch: noarch

%description bom
Protocol Buffer BOM POM.
%endif


%package -n gem-google-protobuf
Summary: Protocol Buffers
Group: Development/Ruby

Provides: gem(google-protobuf) = %EVR

%description -n gem-google-protobuf
Protocol Buffers are Google's data interchange format.

%package -n gem-google-protobuf-doc
Summary: Protocol Buffers documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета google-protobuf
Group: Development/Documentation
BuildArch: noarch

Requires: gem(google-protobuf) = %EVR

%description -n gem-google-protobuf-doc
Protocol Buffers documentation files.

Protocol Buffers are Google's data interchange format.

%description -n gem-google-protobuf-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета google-protobuf.

%package -n gem-google-protobuf-devel
Summary: Protocol Buffers development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета google-protobuf
Group: Development/Ruby
BuildArch: noarch

Requires: gem(google-protobuf) = %EVR
Requires: gem(rake-compiler-dock) >= 1.1.0 gem(rake-compiler-dock) < 2
Requires: gem(rake-compiler) >= 1.1.0 gem(rake-compiler) < 2
Requires: gem(test-unit) >= 3.0 gem(test-unit) < 4

%description -n gem-google-protobuf-devel
Protocol Buffers development package.

Protocol Buffers are Google's data interchange format.

%description -n gem-google-protobuf-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета google-protobuf.

%prep
%setup -n %oname-%version
%patch -p1
%ifarch %e2k
sed -i '$a #ifdef __EDG__\n#undef PROTOBUF_CONSTINIT\n#define PROTOBUF_CONSTINIT\n#endif' \
	src/google/protobuf/port_def.inc
%endif

%if_with java
%pom_remove_plugin org.codehaus.mojo:animal-sniffer-maven-plugin java/util/pom.xml java/pom.xml
%pom_remove_dep com.google.errorprone:error_prone_annotations java/util/pom.xml
%pom_remove_dep com.google.j2objc:j2objc-annotations java/util/pom.xml

# Remove annotation libraries we don't have
annotations=$(
    find -name '*.java' |
      xargs grep -h -e '^import com\.google\.errorprone\.annotation' \
                    -e '^import com\.google\.j2objc\.annotations' |
      sort -u | sed 's/.*\.\([^.]*\);/\1/' | paste -sd\|
)
find -name '*.java' | xargs sed -ri \
    "s/^import .*\.($annotations);//;s/@($annotations)"'\>\s*(\((("[^"]*")|([^)]*))\))?//g'

# These use easymockclassextension
rm java/core/src/test/java/com/google/protobuf/ServiceTest.java
# These use truth or error_prone_annotations or guava-testlib
rm java/core/src/test/java/com/google/protobuf/LiteralByteStringTest.java
rm java/core/src/test/java/com/google/protobuf/BoundedByteStringTest.java
rm java/core/src/test/java/com/google/protobuf/RopeByteStringTest.java
rm java/core/src/test/java/com/google/protobuf/RopeByteStringSubstringTest.java
rm java/core/src/test/java/com/google/protobuf/TextFormatTest.java
rm -r java/util/src/test/java/com/google/protobuf/util
rm -r java/util/src/main/java/com/google/protobuf/util
 
# Make OSGi dependency on sun.misc package optional
%pom_xpath_inject "pom:configuration/pom:instructions" "<Import-Package>sun.misc;resolution:=optional,*</Import-Package>" java/core
 
# Backward compatibility symlink
%mvn_file :protobuf-java:jar: %{name}/%{name}-java %{name}

# This test is incredibly slow on arm/e2k, probably even worse on mipsel
# https://github.com/google/protobuf/issues/2389
%ifnarch %ix86 x86_64
mv java/core/src/test/java/com/google/protobuf/IsValidUtf8Test.java \
   java/core/src/test/java/com/google/protobuf/IsValidUtf8Test.java.slow
mv java/core/src/test/java/com/google/protobuf/DecodeUtf8Test.java \
   java/core/src/test/java/com/google/protobuf/DecodeUtf8Test.java.slow

mv java/core/src/test/java/com/google/protobuf/CheckUtf8Test.java \
   java/core/src/test/java/com/google/protobuf/CheckUtf8Test.java.slow
mv java/core/src/test/java/com/google/protobuf/Proto3SchemaTest.java \
   java/core/src/test/java/com/google/protobuf/Proto3SchemaTest.java.slow
mv java/core/src/test/java/com/google/protobuf/Proto3LiteSchemaTest.java \
   java/core/src/test/java/com/google/protobuf/Proto3LiteSchemaTest.java.slow
%endif
%endif

rm -f src/solaris/libstdc++.la

%build
%ifarch %e2k
# lcc 1.23: be explicit with C++11
%add_optflags -fno-error-always-inline -std=gnu++11
%endif

# Add LTO flags for libutf8_validity.a (static) that is needed
# for utf8_range.pc, that is, in turn, needed for protobuf.pc:
%add_optflags -ffat-lto-objects

iconv -f iso8859-1 -t utf-8 CONTRIBUTORS.txt > CONTRIBUTORS.txt.utf8
mv CONTRIBUTORS.txt.utf8 CONTRIBUTORS.txt

rm -f m4/{lt*,libtool*}.m4

export PTHREAD_LIBS="-lpthread"

%ifarch %ix86
  %add_optflags -D_M_IX86
%endif

%cmake -DCMAKE_CXX_STANDARD=17 \
       -Dprotobuf_USE_EXTERNAL_GTEST=ON \
       -Dprotobuf_BUILD_SHARED_LIBS=ON \
       -Dprotobuf_ABSL_PROVIDER=package \
       -Dutf8_range_ENABLE_INSTALL=OFF
%cmake_build

export PROTOC="$(realpath %_cmake__builddir/protoc)"

%if_with python3
pushd python
%python3_build --cpp_implementation -L../%_cmake__builddir
popd
%endif

%if_with java
%ifarch %ix86 s390x %arm
export MAVEN_OPTS=-Xmx1024m
%endif
%pom_disable_module kotlin java/pom.xml
%pom_disable_module kotlin-lite java/pom.xml
%mvn_build -s %{?_without_java_tests:--skip-tests} -- -f java/pom.xml -Dprotobuf.builddir="$(realpath %_cmake__builddir)"
%endif

%if_with ruby
pushd ruby
rm -fv SetupConfig
%ruby_build
popd
%endif

%install
%cmakeinstall_std

%if_with ruby
pushd ruby
%ruby_install
popd
%endif

%if_with python3
pushd python
%python3_install --cpp_implementation
popd
%endif

%if_with java
%mvn_install
%endif

%check
%ctest

%if_disabled legacy
%files compiler
%_bindir/protoc
%_bindir/protoc-%soversion.*
%endif

%files -n lib%oname%soversion
%doc CONTRIBUTORS.txt README* examples/
%_libdir/*.so.*
%exclude %_libdir/libprotobuf-lite.so.*

%if_disabled legacy
%files -n lib%oname-devel
%dir %_includedir/google/
%_includedir/google/protobuf/
%_pkgconfigdir/%name.pc
%dir %_cmakedir/protobuf
%_cmakedir/protobuf/*.cmake
%_libdir/*.so
%exclude %_libdir/libprotobuf-lite.so
%endif

%files -n lib%oname%soversion-lite
%_libdir/libprotobuf-lite.so.*

%if_disabled legacy
%files -n lib%oname-lite-devel
%_libdir/libprotobuf-lite.so
%_pkgconfigdir/%name-lite.pc

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%endif

%if_with java
%files java -f .mfiles-protobuf-java
%doc examples/AddPerson.java examples/ListPeople.java
%doc java/README.md
%doc LICENSE
%_includedir/java/core/src/main/java/com/google/protobuf/*.proto

%files java-util -f .mfiles-protobuf-java-util

%files javadoc -f .mfiles-javadoc
%doc LICENSE

%files parent -f .mfiles-protobuf-parent
%doc LICENSE

%files bom -f .mfiles-protobuf-bom
%doc LICENSE

%files javalite -f .mfiles-protobuf-javalite
%doc LICENSE
%endif
%endif

%if_with ruby
%files -n gem-google-protobuf
%ruby_gemspecdir/google-protobuf-*.gemspec
%ruby_gemslibdir/google-protobuf-*
%ruby_gemsextdir/google-protobuf-*

%files -n gem-google-protobuf-doc
%ruby_gemsdocdir/google-protobuf-*

%files -n gem-google-protobuf-devel
%_includedir/google/protobuf_c/
%endif


%changelog
