%define _unpackaged_files_terminate_build 1

%def_disable initd
%def_enable doc
%def_enable devel
%def_disable check

Name:          puppetdb
Version:       8.4.1
Release:       alt3
Summary:       Centralized Puppet Storage
License:       Apache-2.0
Group:         Other
Url:           https://docs.puppetlabs.com/puppetdb
Vcs:           https://github.com/puppetlabs/puppetdb.git

BuildArch:     noarch
Source:        %name-%version.tar
Source1:       %name.jar
Source3:       %name.init
Source4:       %name.watch
Source5:       %name.service
Source6:       %name.sysconfig
Autoprov:      yes,nopython,nopython3
Autoreq:       yes,nopython,nopython3
Patch:         %name-%version-%release.patch

BuildRequires(pre): /proc rpm-build-java
BuildRequires(pre): rpm-build-ruby
BuildRequires(pre): rpm-build-pyproject
BuildRequires: java-17-openjdk-devel
BuildRequires: leiningen
BuildRequires: clojure
BuildRequires: python3(wheel)
%if_enabled check
BuildRequires: python3(pytest)
BuildRequires: gem(facter) >= 0
BuildRequires: gem(rake) >= 0
BuildRequires: gem(packaging) >= 0.99
BuildRequires: gem(test-unit) >= 0
BuildRequires: gem(rspec) >= 0
BuildRequires: gem(puppetlabs_spec_helper) = 0.10.3
BuildRequires: gem(puppet) >= 0
BuildRequires: gem(puppet-pson) >= 1.1
BuildRequires: gem(mocha) >= 1.0
BuildRequires: gem(httparty) >= 0
BuildRequires: gem(beaker) >= 4.1
BuildRequires: gem(beaker-hostgenerator) >= 2.2.3
BuildRequires: gem(beaker-abs) >= 0.2
BuildRequires: gem(beaker-vmpooler) >= 1.3
BuildRequires: gem(beaker-puppet) >= 1.0
BuildRequires: gem(faraday) >= 1.8.0
BuildRequires: gem(json) >= 0
BuildRequires: gem(puppet) >= 3.8.1
BuildConflicts: gem(packaging) >= 1
BuildConflicts: gem(puppet-pson) >= 2
BuildConflicts: gem(mocha) >= 2
BuildConflicts: gem(beaker) >= 5
BuildConflicts: gem(beaker-hostgenerator) >= 2.3
BuildConflicts: gem(beaker-abs) >= 1
BuildConflicts: gem(beaker-vmpooler) >= 2
BuildConflicts: gem(beaker-puppet) >= 2
BuildConflicts: gem(faraday) >= 3
BuildConflicts: gem(puppet) >= 9.0
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency faraday >= 2.6.0,faraday < 3
Requires:      puppet
Requires:      postgresql
Requires:      clojure
Requires:      gem(puppetdb-terminus)


%description
PuppetDB is the fast, scalable, and reliable data warehouse for Puppet. It
caches data generated by Puppet, and gives you advanced features at awesome
speed with a powerful API.


%package       -n gem-puppetdb-terminus
Version:       3.0.0
Release:       alt3
Summary:       Connect Puppet to PuppetDB by setting up a terminus for PuppetDB
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(json) >= 0
Requires:      gem(puppet) >= 3.8.1
Conflicts:     gem(puppet) >= 9.0
Provides:      gem(puppetdb-terminus) = 3.0.0

%description   -n gem-puppetdb-terminus
Puppet terminus files to connect to PuppetDB


%if_enabled    doc
%package       -n puppetdb-terminus-doc
Version:       3.0.0
Release:       alt3
Summary:       Connect Puppet to PuppetDB by setting up a terminus for PuppetDB documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета puppetdb-terminus
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(puppetdb-terminus) = 3.0.0

%description   -n puppetdb-terminus-doc
Connect Puppet to PuppetDB by setting up a terminus for PuppetDB documentation
files.

Puppet terminus files to connect to PuppetDB
%description   -n puppetdb-terminus-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета puppetdb-terminus.
%endif


%if_enabled    devel
%package       -n puppetdb-terminus-devel
Version:       3.0.0
Release:       alt3
Summary:       Connect Puppet to PuppetDB by setting up a terminus for PuppetDB development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета puppetdb-terminus
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(puppetdb-terminus) = 3.0.0

%description   -n puppetdb-terminus-devel
Connect Puppet to PuppetDB by setting up a terminus for PuppetDB development
package.

Puppet terminus files to connect to PuppetDB
%description   -n puppetdb-terminus-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета puppetdb-terminus.
%endif


%prep
%setup
%autopatch -p1

%build
NO_ACCEPTANCE=true %ruby_build
#lein uberjar

%install
NO_ACCEPTANCE=true %ruby_install
install -D %SOURCE1 %buildroot%_javadir/%name/%name.jar
install -D -m 644 %SOURCE5 %buildroot%_unitdir/%name.service

%if_enabled initd
install -D %SOURCE3 %buildroot%_initdir/%name
install -D ext/puppetdb.tmpfiles.conf %buildroot%_tmpfilesdir/puppetdb.tmpfiles.conf
mkdir -p %buildroot%_runtimedir/%name
cp ext/puppetdb.logrotate.conf %buildroot%_sysconfdir/logrotate.d/puppetdb
%endif

mkdir -p %buildroot%_sysconfdir/logrotate.d %buildroot%ruby_vendorlibdir/

install -D %SOURCE6 %buildroot%_sysconfdir/sysconfig/%name

install -Dm 0755 pdb %buildroot%_bindir/pdb

install -d -m 0755 %buildroot%_sysconfdir/%name/conf.d
install -d -m 0755 %buildroot%_javadir/%name/cli
install -d -m 0755 %buildroot%_javadir/%name/cli/apps
install -d -m 0755 %buildroot%_logdir/%name
install -d -m 0755 %buildroot%_localstatedir/%name
ln -svr %buildroot%_libexecdir/%name/.m2 %buildroot%_localstatedir/%name/.m2

install resources/ext/ezbake.conf %buildroot%_sysconfdir/%name/ezbake.conf
install resources/ext/config/conf.d/auth.conf %buildroot%_sysconfdir/%name/conf.d/auth.conf
install resources/ext/config/conf.d/jetty.ini %buildroot%_sysconfdir/%name/conf.d/jetty.ini
install resources/ext/config/conf.d/config.ini %buildroot%_sysconfdir/%name/conf.d/config.ini
install resources/ext/config/conf.d/repl.ini %buildroot%_sysconfdir/%name/conf.d/repl.ini
install resources/ext/config/conf.d/database.ini %buildroot%_sysconfdir/%name/conf.d/database.ini
install resources/ext/config/request-logging.xml %buildroot%_sysconfdir/%name/request-logging.xml
install resources/ext/config/bootstrap.cfg %buildroot%_sysconfdir/%name/bootstrap.cfg
install resources/ext/config/logback.xml %buildroot%_sysconfdir/%name/logback.xml

install -m 0755 resources/ext/cli/anonymize %buildroot%_javadir/%name/cli/apps/anonymize
install -m 0755 resources/ext/cli/config-migration %buildroot%_javadir/%name/cli/apps/config-migration
install -m 0755 resources/ext/cli/upgrade %buildroot%_javadir/%name/cli/apps/upgrade
#ruby -rerb -e 'File.open("resources/ext/cli/ssl-setup.erb", "w") { |f| f.puts ERB.new(IO.read("%buildroot%_javadir/%name/cli/apps/ssl-setup")).result }'
#ruby -rerb -e 'File.open("resources/ext/cli/delete-reports.erb", "w") { |f| f.puts ERB.new(IO.read("%buildroot%_javadir/%name/cli/apps/delete-reports")).result }'
cp -pr .m2 %buildroot%_libexecdir/%name/

%check
%ruby_test

%pre
getent group _puppetdb > /dev/null || groupadd -r _puppetdb || :
getent passwd _puppetdb >/dev/null || \
   useradd -r --gid _puppetdb --home %_localstatedir/%name --shell $(which nologin) \
   --comment "puppetdb daemon"  _puppetdb || :

%post
%post_service %name

echo 'NOTE: To complete update/install procedure, make sure you have followed manuals at https://www.altlinux.org/Puppetdb' 1>&2

%preun
%preun_service %name

%files
%_javadir/%name/*
%_libexecdir/%name
%_unitdir/%name.service
%dir %_sysconfdir/%name
%attr(0770,_puppetdb,_puppetdb) %_localstatedir/%name
%if_enabled initd
%_initdir/%name
%_tmpfilesdir/puppetdb.tmpfiles.conf
%_sysconfdir/logrotate.d/%name
%doc ext/docs/%name/*
%endif
%dir %_javadir/%name
%dir %attr(0770,_puppetdb,_puppetdb) %_logdir/%name
%dir %_sysconfdir/%name/conf.d
%dir %_sysconfdir/%name/ezbake.conf
%dir %_sysconfdir/%name/image_templates/ec2.yaml
%dir %_javadir/%name/cli
%dir %_javadir/%name/cli/apps
%_javadir/%name/cli/apps/*
%_bindir/pdb

%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/sysconfig/%name
%config(noreplace) %attr(0770,_puppetdb,_puppetdb) %_sysconfdir/%name/image_templates
%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/%name/image_templates/ec2.yaml
%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/%name/request-logging.xml
%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/%name/conf.d/auth.conf
%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/%name/conf.d/jetty.ini
%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/%name/conf.d/config.ini
%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/%name/conf.d/repl.ini
%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/%name/conf.d/database.ini
%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/%name/bootstrap.cfg
%config(noreplace) %attr(0660,_puppetdb,_puppetdb) %_sysconfdir/%name/logback.xml


%files         -n gem-puppetdb-terminus
%doc README.md
%ruby_gemspecdir/puppetdb-terminus-3.0.0.gemspec
%ruby_gemslibdir/puppetdb-terminus-3.0.0

%if_enabled    doc
%files         -n puppetdb-terminus-doc
%doc README.md
%ruby_gemsdocdir/puppetdb-terminus-3.0.0
%endif

%if_enabled    devel
%files         -n puppetdb-terminus-devel
%doc README.md
%endif


%changelog
