Name: pve-docs
Summary: PVE Documentation
Version: 9.0.8
Release: alt2
License: AGPL-3.0+ and GFDL-1.3+
Group: Documentation
Url: https://git.proxmox.com/

Source: %name-%version.tar

ExclusiveArch: x86_64 aarch64 loongarch64
BuildArch: noarch
BuildRequires: asciidoc-a2x asciidoc-latex asciidoc source-highlight xmlto librsvg-utils mailcap pve-common pve-doc-generator
BuildRequires: perl(MediaWiki/API.pm) perl(JSON.pm)
BuildRequires: pve-manager
BuildRequires: proxmox-widget-toolkit-dev

%description
PVE Documentation files

%prep
%setup -q -n %name-%version
grep 'proxmox.com' * -rl | while read f; do
	sed -i 's|proxmox.com|basealt.ru|' $f
done
sed -i 's|{python}|python3|' asciidoc/*.conf
rm -f getting-help.adoc howto-improve-pve-docs.adoc pve-package-repos.adoc pve-faq.adoc pve-installation.adoc pve-system-requirements.adoc translation.adoc pve-installation-media.adoc cpu-models.conf.adoc firmware-updates.adoc

%build
%make DOCRELEASE=%version

%install

mkdir -p %buildroot%_datadir/%name/{api-viewer,images/screenshot}
install -m644 *.html %buildroot%_datadir/%name/
install -m644 api-viewer/apidoc.js %buildroot%_datadir/%name/api-viewer/
install -m644 api-viewer/index.html %buildroot%_datadir/%name/api-viewer/
install -m644 images/*.svg %buildroot%_datadir/%name/images/
install -m644 images/screenshot/*.png %buildroot%_datadir/%name/images/screenshot/

%files
%doc debian/copyright
%_datadir/%name

%changelog
