%def_without check

Name: pve-network
Summary: PVE SDN package
Version: 1.1.6
Release: alt1
License: AGPL-3.0+
Group: Development/Perl
Url: https://git.proxmox.com/

Source: %name-%version.tar
Patch: alt-dnsmasq.patch

ExclusiveArch: x86_64 aarch64 loongarch64

Provides: libpve-network-perl = %EVR
Requires: ifupdown2
Requires: pve-common >= 9.0.2
Requires: pve-cluster >= 9.0.1
Requires: pve-firewall >= 5.1.0
Requires: frr frr-pythontools
Requires: dnsmasq

BuildRequires: pve-cluster
BuildRequires: pve-firewall
BuildRequires: pve-doc-generator
BuildRequires: perl
BuildRequires: perl(CPAN/Meta/YAML.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Digest/SHA.pm)
BuildRequires: perl(Encode.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Slurp.pm)
BuildRequires: perl(HTTP/Request.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(NetAddr/IP.pm)
BuildRequires: perl(Net/IP.pm)
BuildRequires: perl(Net/Subnet.pm)
BuildRequires: perl(PVE/Cluster.pm)
BuildRequires: perl(PVE/Exception.pm)
BuildRequires: perl(PVE/INotify.pm)
BuildRequires: perl(PVE/JSONSchema.pm)
BuildRequires: perl(PVE/RESTHandler.pm)
BuildRequires: perl(PVE/RPCEnvironment.pm)
BuildRequires: perl(PVE/SafeSyslog.pm)
BuildRequires: perl(PVE/SectionConfig.pm)
BuildRequires: perl(PVE/Tools.pm)
BuildRequires: perl(Test/MockModule.pm)
BuildRequires: perl(Test/More.pm)

%define __spec_autodep_custom_pre export PERL5OPT='-I%buildroot%perl_vendor_privlib -MPVE::Network::SDN'; export TZ=UTC
%set_perl_req_method relaxed

%description
Proxmox VE's experimental SDN (Software Defined Network)
This package contains the experimental SDN library used by Proxmox VE.

%prep
%setup -q -n %name-%version
%patch -p1
sed -i 's!)/lib/systemd/system!)/usr/lib/systemd/system!' src/services/Makefile

%install
%make -C src DESTDIR=%buildroot install

%check
make -C src test

%files
%doc debian/copyright
%perl_vendor_privlib/PVE/*
%_unitdir/dnsmasq@.service.d/00-dnsmasq-after-networking.conf

%changelog
