Name: pychess
Version: 1.0.5
Release: alt1

Summary: Chess game for GNOME
License: GPLv2
Group: Games/Boards
Url: https://github.com/pychess/pychess/
VCS: https://github.com/pychess/pychess.git

BuildArch: noarch

Source: %name-%version.tar
Patch0: pychess-alt-fix-sysprefix-processing-in-hasher.patch
Patch1: pr2235.patch

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: rpm-build-compat >= 1.2
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(sqlite3)
BuildRequires: python3(pexpect)
BuildRequires: python3(sqlalchemy)
BuildRequires: python3(gi)
BuildRequires: python3(cairo)
BuildRequires: gobject-introspection-devel
BuildRequires: librsvg-gir-devel
BuildRequires: python3-module-pygobject3-pygtkcompat

# needed:
Requires: gnome-icon-theme
Requires: typelib(GtkSource) = 3.0

%add_python3_req_skip gi.repository.GdkPixbuf

%filter_from_requires /python2.*/d
%filter_from_requires /typelib(WebKit)/d

%description
PyChess is a GTK+ chess game for Linux. It is designed to at the same time
be easy to use, beautiful to look at, and provide advanced functions for
advanced players

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
PYTHONPATH=lib %__python3 pgn2ecodb.py
PYTHONPATH=lib %__python3 create_theme_preview.py
%pyproject_build

%install
%pyproject_install
%find_lang %name

%files -f %name.lang
%doc AUTHORS LICENSE README.md
%python3_sitelibdir/%name/
%python3_sitelibdir/*.dist-info/
%_bindir/%name
%_datadir/%name/
%_datadir/gtksourceview-3.0/language-specs/pgn.lang
%_datadir/mime/packages/%name.xml
%_datadir/metainfo/%name.metainfo.xml
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/*
%_man1dir/*

%changelog
