%define pypi_name CT3
%define mod_name Cheetah

%def_with check

Name: python3-module-%mod_name
Version: 3.4.0
Release: alt1.1.1

Summary: Template engine and code-generator

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/CT3/
VCS: https://github.com/CheetahTemplate3/cheetah3

Source: %name-%version.tar
# https://github.com/CheetahTemplate3/cheetah3/issues/66
Patch1: cheetah-3.4.0-tox-make-tox-configuration-compatible-with-both-tox3.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%description
Cheetah is an open source template engine and code generation tool, written
in Python. It can be used standalone or combined with other tools and
frameworks. Web development is its principle use, but Cheetah is very
flexible and is also being used to generate C++ game code, Java, sql,
form emails and even Python code.

%package tests
Summary: Tests for Cheetah, template engine and code-generator
Group: Development/Python3
Requires: %name = %EVR

%description tests
Cheetah is an open source template engine and code generation tool, written
in Python. It can be used standalone or combined with other tools and
frameworks. Web development is its principle use, but Cheetah is very
flexible and is also being used to generate C++ game code, Java, sql,
form emails and even Python code.

This package contains tests for Cheetah.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc LICENSE *.rst
%_bindir/cheetah
%_bindir/cheetah-analyze
%_bindir/cheetah-compile
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/%mod_name/Tests

%files tests
%python3_sitelibdir/%mod_name/Tests
%exclude %python3_sitelibdir/%mod_name/Tests/Performance.py*

%changelog
