%define pypi_name Cython
# requires python3(gdb) < 0
%def_disable debugger
%ifarch armh
%def_disable check
%else
%def_disable check
%endif

Name: python3-module-%pypi_name
Version: 3.0.11
Release: alt1

Summary: C-extensions for Python 3
Group: Development/Python3
License: Apache-2.0
Url: http://www.cython.org

Vcs: https://github.com/cython/cython.git
#Source: https://pypi.io/packages/source/C/%pypi_name/%pypi_name-%version.tar.gz
Source: https://github.com/cython/cython/archive/%version/%pypi_name-%version.tar.gz

Provides: python3-module-cython = %EVR

%add_python3_req_skip IPython IPython.core IPython.core.magic IPython.utils IPython.utils.text

# for python w/o distutils
%filter_from_requires /python3(distutils.*)/d
Requires: python3(setuptools._distutils)

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3(wheel) python3(setuptools)
%{?_enable_check:BuildRequires: python3-module-tox
BuildRequires: gcc-c++ libgomp-devel
BuildRequires: python3-module-coverage python3-module-pycodestyle
BuildRequires: python3-module-numpy libnumpy-py3-devel}

%description
Cython is a language that makes writing C extensions for the Python 3
language as easy as Python itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python
code.

%package tests
Summary: Cython test suit
Group: Development/Python3
Requires: %name = %EVR

%description tests
Cython is a language that makes writing C extensions for the Python
language as easy as Python itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python3 language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python
code.

This package provides modules for testing Cython using unittest.

%package debugger
Summary: Cython debugger
Group: Development/Python3
Requires: %name = %EVR
Requires: gdb

%description debugger
Cython is a language that makes writing C extensions for the Python
language as easy as Python itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python3 language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python 3
code.

This package provides modules for debugging Cython programms.

%prep
%setup -n cython-%version

%build
%pyproject_build

%install
%pyproject_install
for f in cy{thon{,ize},gdb}; do
ln -s $f %buildroot/%_bindir/"$f"3;
done

%check
%tox_check

%files
%_bindir/cython
%_bindir/cythonize
%_bindir/cython3
%_bindir/cythonize3
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/pyximport/
%python3_sitelibdir/cython.py
%python3_sitelibdir/__pycache__/cython.*
%python3_sitelibdir/*.dist-info
%doc CHANGES* README* USAGE*

%exclude %python3_sitelibdir/%pypi_name/Tests
%exclude %python3_sitelibdir/%pypi_name/Debugger

%files tests
%python3_sitelibdir/%pypi_name/Tests

%if_enabled debugger
%files debugger
%python3_sitelibdir/%pypi_name/Debugger
%_bindir/cygdb
%_bindir/cygdb3
%endif

%changelog
