%define oname ExtensionClass

%def_with check

Name: python3-module-%oname
Version: 5.1
Release: alt1

Summary: Metaclass for subclassable extension types
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/ExtensionClass/
Vcs: https://github.com/zopefoundation/ExtensionClass.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.testrunner
%endif

%description
ExtensionClass:
This package provides a metaclass that allows classes implemented in
extension modules to be subclassed in Python. Unless you need
ExtensionClasses for legacy applications (e.g. Zope 2), you probably
want to use Python's new-style classes (available since Python 2.2).

ComputedAttribute:
This package provides a way to attach attributes to an ExtensionClass or
instance that are computed by calling a callable. This works very much
like property known from new-style classes, except that a
ComputedAttribute can also be attached to an instance and that it
honours ExtensionClass semantics (which is useful for retaining
Acquisition wrappers, for example).

MethodObject:
This package lets you attach additional "methods" to ExtensionClasses.
These "methods" are actually implemented by subclassing the
MethodObject.Method class and implementing the __call__ method there.
Instances of those classes will be bound to the instances they're
attached to and will receive that instance object as a first parameter
(after self).

%package tests
Summary: Tests for ExtensionClass, ComputedAttribute and MethodObject
Group: Development/Python3
Requires: %name = %EVR

%description tests
Tests for ExtensionClass, ComputedAttribute and MethodObject.

%prep
%setup

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests.*

%files tests
%python3_sitelibdir/*/tests.*


%changelog
